package meshvizxlm.eclipsemeshviz.wrappers.geometry;

import com.openinventor.meshvizxlm.MxTimeStamp;
import com.openinventor.meshvizxlm.mesh.geometry.MiGeometryI;

import meshvizxlm.eclipsemeshviz.pillargrid.PillarGrid;

public class PillarGeometry implements MiGeometryI
{
  protected PillarGrid m_grid;
  private long m_timeStamp;

  public PillarGeometry(PillarGrid grid)
  {
    m_grid = grid;
    m_timeStamp = MxTimeStamp.getTimeStamp();
  }

  public double getXMin()
  {
    return m_grid.getXMin();
  }

  public double getYMin()
  {
    return m_grid.getYMin();
  }

  public double getZMin()
  {
    return m_grid.getZMin();
  }

  public double getXMax()
  {
    return m_grid.getXMax();
  }

  public double getYMax()
  {
    return m_grid.getYMax();
  }

  public double getZMax()
  {
    return m_grid.getZMax();
  }

  @Override
  public long getTimeStamp()
  {
    return m_timeStamp;
  }

  protected double[] generateCoord(long id)
  {
    return m_grid.computePillarVertex((int) id);
  }

  @Override
  public double[] getCoord(long i)
  {
    return generateCoord(i);
  }

  public long size()
  {
    return m_grid.getNumZCorns();
  }

  public long getMemoryFootPrint()
  {
    return 0;
  }
}
