package meshvizxlm.eclipsemeshviz.wrappers.property;

import meshvizxlm.eclipsemeshviz.pillargrid.PillarGrid;

public class AnimatedPillarPorosity extends PillarPorosity
{

  private int m_frame;
  private double[] m_unit_sin_table;
  static int NUM_FRAMES = 100;
  static double TWO_PI = 2 * Math.PI;
  double m_range;
  private int m_halfI;
  private int m_halfJ;

  public AnimatedPillarPorosity(PillarGrid grid)
  {
    super(grid);
    m_frame = 0;
    m_unit_sin_table = new double[NUM_FRAMES];
    m_halfI = m_grid.getDimI() / 2;
    m_halfJ = m_grid.getDimJ() / 2;

    int i;
    for ( i = 0; i < NUM_FRAMES; i++ )
    {
      m_unit_sin_table[i] = -1.0;
    }
    m_range = ((getMax() - getMin()) / 10);
  }

  @Override
  public double get(int i, int j, int k)
  {
    double original_val = super.get(i, j, k);

    if ( m_frame == 0 )
    {
      return original_val;
    }

    if ( m_unit_sin_table[m_frame] < 0.0 )
    {
      m_unit_sin_table[m_frame] = Math.sin(TWO_PI * (m_frame / 100.0));
    }

    double unit = m_unit_sin_table[m_frame];

    return original_val + 0.02 * unit * (i / m_halfI) + 0.02 * unit * (j / m_halfJ);
  }

  public void setFrame(int frame)
  {
    if ( m_frame != frame )
    {
      m_frame = frame;

      touch();
    }
  }

  public int getFrame()
  {
    return m_frame;
  }

}
