package meshvizxlm.eclipsemeshviz.wrappers.property;

import meshvizxlm.eclipsemeshviz.pillargrid.PillarGrid;

public class PillarPorosity extends PillarProperty
{

  public PillarPorosity(PillarGrid grid)
  {
    super(grid);
    m_min = 0;
    m_max = 0;
    initMin();
    initMax();
  }

  double m_min;
  double m_max;

  @Override
  public double get(int i, int j, int k)
  {
    return m_grid.getPorosity(i, j, k);
  }

  @Override
  public double getMin()
  {
    return m_min;
  }

  @Override
  public double getMax()
  {
    return m_max;
  }

  public void initMin()
  {
    double min = 999999.99;
    for ( int i = 0; i < m_grid.getDimI() * m_grid.getDimJ() * m_grid.getDimK(); ++i )
    {
      if ( m_grid.getNonIndexedPorosity(i) < min )
        min = m_grid.getNonIndexedPorosity(i);
    }
    m_min = min;
  }

  public void initMax()
  {
    double max = -999999.99;
    for ( int i = 0; i < m_grid.getDimI() * m_grid.getDimJ() * m_grid.getDimK(); ++i )
    {
      if ( m_grid.getNonIndexedPorosity(i) > max )
        max = m_grid.getNonIndexedPorosity(i);
    }
    m_max = max;
  }
}
