package meshvizxlm.eclipsemeshviz.wrappers.property;

import meshvizxlm.eclipsemeshviz.pillargrid.PillarGrid;
import meshvizxlm.mesh.data.MbDataSet;

import com.openinventor.meshvizxlm.mesh.StorageLayoutIJK;
import com.openinventor.meshvizxlm.mesh.data.DataBinding;

public class PillarProperty extends MbDataSet implements BoundedProperty
{
  protected PillarGrid m_grid;
  private double m_min;
  private double m_max;

  protected double m_scale;
  protected double m_halfIRange;
  protected double m_halfJRange;

  public PillarProperty(PillarGrid grid)
  {
    super("PillarProperty", DataBinding.PER_CELL);

    m_grid = grid;
    m_min = m_grid.getMin()[2];
    m_max = m_grid.getMax()[2];
  }

  @Override
  public double getMin()
  {
    return m_min;
  }

  @Override
  public double getMax()
  {
    return m_max;
  }

  @Override
  public double get(int i, int j, int k)
  {
    return m_grid.getProperty(i, j, k);
  }

  @Override
  public StorageLayoutIJK getStorageLayout()
  {
    return StorageLayoutIJK.UNKNOWN;
  }
}
