package meshvizxlm.eclipsemeshviz.wrappers.subsampled;

import com.openinventor.meshvizxlm.MxTimeStamp;
import com.openinventor.meshvizxlm.mesh.StorageLayoutIJK;
import com.openinventor.meshvizxlm.mesh.data.DataBinding;

import meshvizxlm.eclipsemeshviz.wrappers.property.BoundedProperty;

public class SubSampledScalarSet implements BoundedProperty
{

  protected BoundedProperty m_dataset;
  protected long m_dataTS;
  protected long m_timeStamp;
  protected int m_step;

  public SubSampledScalarSet(BoundedProperty dataset, int numI, int numJ, int numK, int step)
  {
    m_dataset = dataset;
    m_dataTS = dataset.getTimeStamp();
    m_step = step;
  }

  public void adjust(int step)
  {
    m_step = step;
    m_timeStamp = MxTimeStamp.getTimeStamp();
  }

  @Override
  public double getMin()
  {
    return m_dataset.getMin();
  }

  @Override
  public double getMax()
  {
    return m_dataset.getMax();
  }

  @Override
  public long getTimeStamp()
  {
    final long dataTS = m_dataset.getTimeStamp();
    if ( m_dataTS != dataTS )
    {
      m_timeStamp = MxTimeStamp.getTimeStamp();
      m_dataTS = dataTS;
    }

    return m_timeStamp;
  }

  @Override
  public String getName()
  {
    return m_dataset.getName();
  }

  @Override
  public DataBinding getBinding()
  {
    return DataBinding.PER_CELL;
  }

  @Override
  public double get(int i, int j, int k)
  {
    return m_dataset.get(i * m_step, j * m_step, k * m_step);
  }

  @Override
  public StorageLayoutIJK getStorageLayout()
  {
    return StorageLayoutIJK.UNKNOWN;
  }

}
