package meshvizxlm.eclipsemeshviz.wrappers.topology;

import meshvizxlm.eclipsemeshviz.DemoSettings;
import meshvizxlm.eclipsemeshviz.pillargrid.PillarEGrid;
import meshvizxlm.eclipsemeshviz.pillargrid.PillarGrid;
import meshvizxlm.eclipsemeshviz.pillargrid.PillarGridJIK;
import meshvizxlm.eclipsemeshviz.wrappers.geometry.AbstractCachedPillarGeometry;

public class CachedPillarTopology<T extends PillarGrid> extends PillarTopology<T>
{
  private int[] m_indices;
  private long m_endNodeId;
  private int m_numK;
  private int m_numKxI;
  private int[] m_next_direction = new int[8];

  private void init()
  {
    m_next_direction[0] = 0;
    m_next_direction[1] = -m_numK;
    m_next_direction[3] = -m_numKxI;
    m_next_direction[2] = m_next_direction[3] + m_next_direction[1];

    m_next_direction[4] = -1;
    m_next_direction[5] = m_next_direction[1] - 1;
    m_next_direction[6] = m_next_direction[2] - 1;
    m_next_direction[7] = m_next_direction[3] - 1;

    for ( int c = 0; c < m_numCorners; ++c )
    {
      m_next_direction[c] *= m_numCorners;
      m_next_direction[c] += c;
    }
  }

  private void generateCellNodeIndices(PillarGridJIK grid, AbstractCachedPillarGeometry geometry)
  {
    float[] zcorns;
    float current_zcorn;
    int previous_corner;
    int[] zcornIds = new int[8];
    int refZcornId;
    long offset, refCell2dId = 0, refcellId = 0;
    int nPillarI = grid.getDimI() + 1;
    int nPillarJ = grid.getDimJ() + 1;
    int nLayerK = grid.getDimK() + 1;

    if ( DemoSettings.HORIZONTAL_FAULTS )
      zcorns = new float[8];
    else
      zcorns = new float[4];

    for ( int j = 0; j < nPillarJ; ++j, refCell2dId -= m_numK )
      for ( int i = 0; i < nPillarI; ++i, refCell2dId += m_numK )
      {
        refcellId = refCell2dId;
        for ( int k = 0; k < nLayerK; ++k, ++refcellId )
        {
          refZcornId = grid.getPillarZCorns(i, j, k, zcorns);

          // check each corner with another and use
          // use same index if shared
          for ( int cn = 0; cn < m_numCorners; ++cn )
          {
            if ( zcorns[cn] != PillarGrid.UNDEF )
            {
              offset = refcellId * m_numCorners + m_next_direction[cn];
              current_zcorn = zcorns[cn];
              previous_corner = cn;
              do
              {
                --previous_corner;
              }
              while ( previous_corner >= 0 && current_zcorn != zcorns[previous_corner] );
              if ( previous_corner < 0 )
                zcornIds[cn] = geometry.addPoint(refZcornId + cn);
              else
                zcornIds[cn] = zcornIds[previous_corner];
              m_indices[(int) offset] = zcornIds[cn];
            }
          }
        }
      }
    m_endNodeId = geometry.size();
  }

  private void generateCellNodeIndices(PillarEGrid grid, AbstractCachedPillarGeometry geometry)
  {
    float[] zcornsCoord = new float[8];
    int[] zcornsId = new int[8];

    float current_zcorn;
    int previous_corner;
    long offset;
    long refCell2dId = 0, refcellId = 0;
    int nPillarI = grid.getDimI() + 1;
    int nPillarJ = grid.getDimJ() + 1;
    int nLayerK = grid.getDimK() + 1;

    for ( int j = 0; j < nPillarJ; ++j, refCell2dId -= m_numK )
      for ( int i = 0; i < nPillarI; ++i, refCell2dId += m_numK )
      {
        refcellId = refCell2dId;
        for ( int k = 0; k < nLayerK; ++k, ++refcellId )
        {
          grid.getPillarZCorns(i, j, k, zcornsCoord, zcornsId);

          // check each corner with another and use
          // use same index if shared
          for ( int cn = 0; cn < m_numCorners; ++cn )
          {
            if ( zcornsCoord[cn] != PillarGrid.UNDEF )
            {
              offset = refcellId * m_numCorners + m_next_direction[cn];
              current_zcorn = zcornsCoord[cn];
              previous_corner = cn;
              do
              {
                --previous_corner;
              }
              while ( previous_corner >= 0 && current_zcorn != zcornsCoord[previous_corner] );
              if ( previous_corner < 0 )
                zcornsId[cn] = geometry.addPoint(zcornsId[cn]);
              else
                zcornsId[cn] = zcornsId[previous_corner];
              m_indices[(int) offset] = zcornsId[cn];
            }
          }
        }
      }
    m_endNodeId = geometry.size();
  }

  public CachedPillarTopology(T grid, AbstractCachedPillarGeometry geometry)
  {
    super(grid);
    if ( DemoSettings.HORIZONTAL_FAULTS )
    {
      m_numK = grid.getDimK();
      m_indices = new int[getNumCells() * 8];
    }
    else
    {
      m_numK = grid.getDimK() + 1;
      m_indices = new int[grid.getDimI() * grid.getDimJ() * (grid.getDimK() + 1) * 4];
    }

    m_numKxI = m_numK * grid.getDimI();
    init();
    if ( grid instanceof PillarEGrid )
      generateCellNodeIndices((PillarEGrid) grid, geometry);
    else
      generateCellNodeIndices((PillarGridJIK) grid, geometry);
  }

  @Override
  public long[] getCellNodeIndices(int i, int j, int k, long[] nodeIndices)
  {
    if ( null == nodeIndices || nodeIndices.length < 8 )
      nodeIndices = new long[8];

    int start = (j * m_numKxI + i * m_numK + k) * m_numCorners;
    nodeIndices[0] = m_indices[start++];
    nodeIndices[1] = m_indices[start++];
    nodeIndices[2] = m_indices[start++];
    nodeIndices[3] = m_indices[start++];
    nodeIndices[4] = m_indices[start++];
    nodeIndices[5] = m_indices[start++];
    nodeIndices[6] = m_indices[start++];
    nodeIndices[7] = m_indices[start];
    return nodeIndices;
  }

  @Override
  public long getEndNodeId()
  {
    return m_endNodeId;
  }

  @Override
  public long getMemoryFootPrint()
  {
    return 4 * m_indices.length;
  }
}
