package meshvizxlm.eclipsemeshviz.wrappers.topology;

import meshvizxlm.eclipsemeshviz.DemoSettings;
import meshvizxlm.eclipsemeshviz.pillargrid.PillarEGrid;

public class PillarEGridTopology extends PillarTopology<PillarEGrid>
{

  public PillarEGridTopology(PillarEGrid grid)
  {
    super(grid);
  }

  @Override
  public long[] getCellNodeIndices(int i, int j, int k, long[] nodeIndices)
  {
    float[] coords = new float[8];
    int[] indices = new int[8];
    int[] zcornId = new int[8];
    long corner;
    float zcorn;

    if ( null == nodeIndices || nodeIndices.length < 8 )
      nodeIndices = new long[8];

    m_grid.getPillarZCorns(i, j, k, coords, indices);
    nodeIndices[0] = zcornId[0] = indices[0];

    m_grid.getPillarZCorns(i + 1, j, k, coords, indices);
    corner = 0;
    if ( coords[1] != coords[0] )
      corner = 1;
    nodeIndices[1] = zcornId[1] = indices[(int) corner];

    for ( int n = 2; n < m_numCorners; ++n )
    {
      m_grid.getPillarZCorns(i + s_direction[n][0], j + s_direction[n][1], k + s_direction[n][2], coords, indices);
      corner = 0;
      zcorn = coords[n];
      while ( zcorn != coords[(int) corner] )
        ++corner;
      zcornId[n] = indices[(int) corner];
    }

    nodeIndices[2] = zcornId[2];
    nodeIndices[3] = zcornId[3];

    if ( DemoSettings.HORIZONTAL_FAULTS )
    {
      nodeIndices[4] = zcornId[4];
      nodeIndices[5] = zcornId[5];
      nodeIndices[6] = zcornId[6];
      nodeIndices[7] = zcornId[7];
    }
    else
    {
      if ( k + 1 < m_grid.getDimK() )
      {
        nodeIndices[4] = m_grid.getNextUpperCellFaceZCornId(zcornId[0]);
        nodeIndices[5] = m_grid.getNextUpperCellFaceZCornId(zcornId[1]);
        nodeIndices[6] = m_grid.getNextUpperCellFaceZCornId(zcornId[2]);
        nodeIndices[7] = m_grid.getNextUpperCellFaceZCornId(zcornId[3]);
      }
      else
      {
        nodeIndices[4] = m_grid.getNextUpperFaceZCornId(zcornId[0]);
        nodeIndices[5] = m_grid.getNextUpperFaceZCornId(zcornId[1]);
        nodeIndices[6] = m_grid.getNextUpperFaceZCornId(zcornId[2]);
        nodeIndices[7] = m_grid.getNextUpperFaceZCornId(zcornId[3]);
      }
    }

    return nodeIndices;
  }
}
