package meshvizxlm.mapping.slab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoShapeHints;
import com.openinventor.inventor.nodes.SoSwitch;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;
import com.openinventor.meshvizxlm.mapping.nodes.*;
import com.openinventor.meshvizxlm.mesh.Dimension;
import com.openinventor.meshvizxlm.mesh.cell.MiCellFilterIjk;

import meshvizxlm.mesh.MbSampleMeshBuilder;
import meshvizxlm.mesh.data.MbScalarSetI;
import meshvizxlm.mesh.data.MbScalarSetIjk;
import meshvizxlm.mesh.volumes.MbHexahedronMeshIjk;
import meshvizxlm.mesh.volumes.MbVertexHexahedronMeshIjk;
import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private static final java.awt.Dimension SLIDER_TEXT_DIM = new java.awt.Dimension(80, 20);

  // ///// INNER CLASS
  class CellFilterIjk implements MiCellFilterIjk
  {
    @Override
    public boolean acceptCell(int i, int j, int k)
    {
      if ( DIM / 3. < i && i <= 2 * DIM / 3. && DIM / 3. < j && j <= 2 * DIM / 3. && k > DIM / 2. )
        return false;

      return true;
    }

    @Override
    public long getTimeStamp()
    {
      return 0;
    }
  }

  private static final int DIM = 30;
  private static final String SCALARSET_I_NAME = "$ScalarSetX";
  private static final String SCALARSET_IJK_NAME = "$CellId";

  private MoMesh m_moMesh;

  private SoSwitch m_filterSwitch;
  private SoSwitch m_outlineSwitch;
  private SoSwitch m_slabISwitch;
  private SoSwitch m_slabJSwitch;
  private SoSwitch m_slabKSwitch;

  private MoMeshSlab m_slabI;
  private MoMeshSlab m_slabJ;
  private MoMeshSlab m_slabK;

  private MoPredefinedColorMapping m_colMap;

  private MbHexahedronMeshIjk m_meshHexaIjk;
  private MbVertexHexahedronMeshIjk m_meshVertexHexaIjk;
  private IViewerExaminer m_renderArea;

  public Main()
  {
    double[] min = { 0, 0, 0 };
    double[] max = { 10, 10, 10 };

    MbSampleMeshBuilder meshBuilder = new MbSampleMeshBuilder();
    m_meshHexaIjk = meshBuilder.getHexahedronMeshIjk(DIM, DIM, DIM, min, max);
    m_meshVertexHexaIjk = meshBuilder.getVertexHexahedronMeshIjk(DIM, DIM, DIM, min, max);
  }

  @Override
  public void start()
  {
    SoSeparator root = buildSceneGraph();

    m_renderArea = ViewerComponentsFactory.createViewerExaminer();
    m_renderArea.setSceneGraph(root);
    m_renderArea.viewAll();

    // SWING part
    final JCheckBox outlineCheckBox = new JCheckBox("Outline");
    outlineCheckBox.setSelected(m_outlineSwitch.whichChild.getValue() == SoSwitch.SO_SWITCH_ALL);
    outlineCheckBox.addItemListener(new ItemListener()
    {
      @Override
      public void itemStateChanged(ItemEvent e)
      {
        if ( outlineCheckBox.isSelected() )
          m_outlineSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
        else
          m_outlineSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
      }
    });

    final JCheckBox cellfilterCheckBox = new JCheckBox("Cell filter");
    cellfilterCheckBox.setSelected(m_filterSwitch.whichChild.getValue() == SoSwitch.SO_SWITCH_ALL);
    cellfilterCheckBox.addItemListener(new ItemListener()
    {
      @Override
      public void itemStateChanged(ItemEvent e)
      {
        if ( cellfilterCheckBox.isSelected() )
          m_filterSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
        else
          m_filterSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
      }
    });

    JPanel checkboxPanel = new JPanel();
    checkboxPanel.setLayout(new BoxLayout(checkboxPanel, BoxLayout.X_AXIS));
    checkboxPanel.add(outlineCheckBox);
    checkboxPanel.add(cellfilterCheckBox);

    JPanel slabISliderPanel = new JPanel();
    slabISliderPanel
        .setBorder(new TitledBorder(new EtchedBorder(), "I Axis", TitledBorder.LEADING, TitledBorder.TOP, null, null));
    slabISliderPanel.setLayout(new GridLayout(0, 1, 0, 0));

    final JCheckBox slabIVisible = new JCheckBox("Visible");
    slabIVisible.setSelected(m_slabISwitch.whichChild.getValue() == SoSwitch.SO_SWITCH_ALL);
    slabIVisible.addItemListener(new ItemListener()
    {
      @Override
      public void itemStateChanged(ItemEvent e)
      {
        if ( slabIVisible.isSelected() )
          m_slabISwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
        else
          m_slabISwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
      }
    });
    slabISliderPanel.add(slabIVisible);

    SliderPanel slabIposSliderPanel = new SliderPanel(0, DIM - 1, m_slabI.index.getValue());
    ((FlowLayout) slabIposSliderPanel.getLayout()).setAlignment(FlowLayout.LEFT);
    slabIposSliderPanel.addInfoText("index");
    slabIposSliderPanel.setInfoTextSize(SLIDER_TEXT_DIM);
    slabIposSliderPanel.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        m_slabI.index.setValue((int) value);
      }
    });
    slabISliderPanel.add(slabIposSliderPanel);

    SliderPanel slabIwidthSliderPanel = new SliderPanel(-DIM, DIM, m_slabI.thickness.getValue());
    ((FlowLayout) slabIwidthSliderPanel.getLayout()).setAlignment(FlowLayout.LEFT);
    slabIwidthSliderPanel.addInfoText("thickness");
    slabIwidthSliderPanel.setInfoTextSize(SLIDER_TEXT_DIM);
    slabIwidthSliderPanel.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        m_slabI.thickness.setValue((int) value);
      }
    });
    slabISliderPanel.add(slabIwidthSliderPanel);

    JPanel slabJSliderPanel = new JPanel();
    slabJSliderPanel
        .setBorder(new TitledBorder(new EtchedBorder(), "J Axis", TitledBorder.LEADING, TitledBorder.TOP, null, null));
    slabJSliderPanel.setLayout(new GridLayout(0, 1, 0, 0));

    final JCheckBox slabJVisible = new JCheckBox("Visible");
    slabJVisible.setSelected(m_slabJSwitch.whichChild.getValue() == SoSwitch.SO_SWITCH_ALL);
    slabJVisible.addItemListener(new ItemListener()
    {
      @Override
      public void itemStateChanged(ItemEvent e)
      {
        if ( slabJVisible.isSelected() )
          m_slabJSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
        else
          m_slabJSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
      }
    });
    slabJSliderPanel.add(slabJVisible);

    SliderPanel slabJposSliderPanel = new SliderPanel(0, DIM - 1, m_slabJ.index.getValue());
    ((FlowLayout) slabJposSliderPanel.getLayout()).setAlignment(FlowLayout.LEFT);
    slabJposSliderPanel.addInfoText("index");
    slabJposSliderPanel.setInfoTextSize(SLIDER_TEXT_DIM);
    slabJposSliderPanel.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        m_slabJ.index.setValue((int) value);
      }
    });
    slabJSliderPanel.add(slabJposSliderPanel);

    SliderPanel slabJwidthSliderPanel = new SliderPanel(-DIM, DIM, m_slabJ.thickness.getValue());
    ((FlowLayout) slabJwidthSliderPanel.getLayout()).setAlignment(FlowLayout.LEFT);
    slabJwidthSliderPanel.addInfoText("thickness");
    slabJwidthSliderPanel.setInfoTextSize(SLIDER_TEXT_DIM);
    slabJwidthSliderPanel.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        m_slabJ.thickness.setValue((int) value);
      }
    });
    slabJSliderPanel.add(slabJwidthSliderPanel);

    JPanel slabKSliderPanel = new JPanel();
    slabKSliderPanel
        .setBorder(new TitledBorder(new EtchedBorder(), "K Axis", TitledBorder.LEADING, TitledBorder.TOP, null, null));
    slabKSliderPanel.setLayout(new GridLayout(0, 1, 0, 0));

    final JCheckBox slabKVisible = new JCheckBox("Visible");
    slabKVisible.setSelected(m_slabKSwitch.whichChild.getValue() == SoSwitch.SO_SWITCH_ALL);
    slabKVisible.addItemListener(new ItemListener()
    {
      @Override
      public void itemStateChanged(ItemEvent e)
      {
        if ( slabKVisible.isSelected() )
          m_slabKSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
        else
          m_slabKSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
      }
    });
    slabKSliderPanel.add(slabKVisible);

    SliderPanel slabKposSliderPanel = new SliderPanel(0, DIM - 1, m_slabK.index.getValue());
    ((FlowLayout) slabKposSliderPanel.getLayout()).setAlignment(FlowLayout.LEFT);
    slabKposSliderPanel.addInfoText("index");
    slabKposSliderPanel.setInfoTextSize(SLIDER_TEXT_DIM);
    slabKposSliderPanel.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        m_slabK.index.setValue((int) value);
      }
    });
    slabKSliderPanel.add(slabKposSliderPanel);

    SliderPanel slabKwidthSliderPanel = new SliderPanel(-DIM, DIM, m_slabK.thickness.getValue());
    ((FlowLayout) slabKwidthSliderPanel.getLayout()).setAlignment(FlowLayout.LEFT);
    slabKwidthSliderPanel.addInfoText("thickness");
    slabKwidthSliderPanel.setInfoTextSize(SLIDER_TEXT_DIM);
    slabKwidthSliderPanel.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        m_slabK.thickness.setValue((int) value);
      }
    });
    slabKSliderPanel.add(slabKwidthSliderPanel);

    JPanel sliderPanel = new JPanel();
    sliderPanel.setLayout(new BoxLayout(sliderPanel, BoxLayout.Y_AXIS));
    sliderPanel.add(slabISliderPanel);
    sliderPanel.add(slabJSliderPanel);
    sliderPanel.add(slabKSliderPanel);

    JPanel meshPanel = new JPanel();
    meshPanel
        .setBorder(new TitledBorder(new EtchedBorder(), "Mesh", TitledBorder.LEADING, TitledBorder.TOP, null, null));
    meshPanel.setLayout(new BorderLayout());
    String[] items = new String[] { "Hexahedron IJK", "Vertex Hexahedron IJK" };
    final JComboBox<String> meshBox = new JComboBox<>(items);
    meshBox.setSelectedIndex(0);
    meshBox.addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent e)
      {
        int selectedIndex = meshBox.getSelectedIndex();

        if ( selectedIndex == 0 )
        { // hexahedron IJK
          m_moMesh.setMesh(m_meshHexaIjk);
          MbScalarSetI scalarSet = m_meshHexaIjk.getScalarSet(SCALARSET_I_NAME);
          m_colMap.minValue.setValue((float) scalarSet.getMin());
          m_colMap.maxValue.setValue((float) scalarSet.getMax());
        }
        else
        { // Vertex hexahedron IJK
          m_moMesh.setMesh(m_meshVertexHexaIjk);
          MbScalarSetIjk scalarSetIjk = m_meshVertexHexaIjk.getScalarSetIjk(SCALARSET_IJK_NAME);
          m_colMap.minValue.setValue((float) scalarSetIjk.getMin());
          m_colMap.maxValue.setValue((float) scalarSetIjk.getMax());
        }
      }
    });
    meshPanel.add(meshBox, BorderLayout.CENTER);

    JPanel panel = new JPanel();
    panel.setLayout(new BorderLayout());
    panel.add(checkboxPanel, BorderLayout.NORTH);
    panel.add(sliderPanel, BorderLayout.CENTER);
    panel.add(meshPanel, BorderLayout.SOUTH);

    final Component component = m_renderArea.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
    add(panel, BorderLayout.SOUTH);
  }

  @Override
  public void stop()
  {
    m_renderArea.dispose();
  }

  private SoSeparator buildSceneGraph()
  {
    SoShapeHints sh = new SoShapeHints();
    sh.vertexOrdering.setValue(SoShapeHints.VertexOrderings.CLOCKWISE);

    m_moMesh = new MoMesh();
    m_moMesh.setMesh(m_meshHexaIjk);

    // Cell filter
    m_filterSwitch = new SoSwitch();
    m_filterSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
    MoCellFilter cellFilter = new MoCellFilter();
    cellFilter.setCellFilter(new CellFilterIjk());

    // Data binding
    MoDataBinding dataBinding = new MoDataBinding();
    dataBinding.dataBinding.setValue(MoDataBinding.DataBinding.PER_NODE);

    // Data set
    MbScalarSetI scalarSet = m_meshHexaIjk.getScalarSet(SCALARSET_I_NAME);
    m_colMap = new MoPredefinedColorMapping();
    m_colMap.minValue.setValue((float) scalarSet.getMin());
    m_colMap.maxValue.setValue((float) scalarSet.getMax());
    m_colMap.predefColorMap.setValue(MoPredefinedColorMapping.PredefColorMapping.BLUE_RED);

    MoScalarSetI moScalarSetI = new MoScalarSetI();
    moScalarSetI.setScalarSet(scalarSet);

    MbScalarSetIjk scalarSetIjk = m_meshVertexHexaIjk.getScalarSetIjk(SCALARSET_IJK_NAME);

    MoScalarSetIjk moScalarSetIjk = new MoScalarSetIjk();
    moScalarSetIjk.setScalarSet(scalarSetIjk);

    // Slabs
    int mid = DIM / 2;
    m_slabI = new MoMeshSlab();
    m_slabI.index.setValue(mid);
    m_slabI.dimension.setValue(Dimension.I);
    // Use data set 0 for coloring
    m_slabI.colorScalarSetId.setValue(0);

    m_slabISwitch = new SoSwitch();
    m_slabISwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);

    m_slabJ = new MoMeshSlab();
    m_slabJ.index.setValue(mid);
    m_slabJ.dimension.setValue(Dimension.J);
    // Use data set 0 for coloring
    m_slabJ.colorScalarSetId.setValue(0);

    m_slabJSwitch = new SoSwitch();
    m_slabJSwitch.whichChild.setValue(SoSwitch.WhichChild.SO_SWITCH_NONE.getValue());

    m_slabK = new MoMeshSlab();
    m_slabK.index.setValue(mid);
    m_slabK.dimension.setValue(Dimension.K);
    // Use data set 0 for coloring
    m_slabK.colorScalarSetId.setValue(0);

    m_slabKSwitch = new SoSwitch();
    m_slabKSwitch.whichChild.setValue(SoSwitch.WhichChild.SO_SWITCH_NONE.getValue());

    // Outline
    MoMeshOutline outline = new MoMeshOutline();
    outline.colorScalarSetId.setValue(0);

    m_outlineSwitch = new SoSwitch();
    m_outlineSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);

    SoSeparator root = new SoSeparator();
    {
      m_filterSwitch.addChild(cellFilter);

      m_slabISwitch.addChild(m_slabI);
      m_slabJSwitch.addChild(m_slabJ);
      m_slabKSwitch.addChild(m_slabK);

      m_outlineSwitch.addChild(outline);

      root.addChild(sh);
      root.addChild(m_moMesh);
      root.addChild(m_filterSwitch);
      root.addChild(m_colMap);
      root.addChild(dataBinding);
      root.addChild(moScalarSetI);
      root.addChild(moScalarSetIjk);
      root.addChild(m_slabISwitch);
      root.addChild(m_slabJSwitch);
      root.addChild(m_slabKSwitch);
      root.addChild(m_outlineSwitch);
    }

    return root;
  }

  public static void main(String[] args)
  {
    Main example = new Main();
    example.demoMain("Slab demo");
  }

}
