package meshvizxlm.mapping.surfacecellfilter;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoShapeHints;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;
import com.openinventor.meshvizxlm.mapping.nodes.MoCellFilter;
import com.openinventor.meshvizxlm.mapping.nodes.MoCellRanges;
import com.openinventor.meshvizxlm.mapping.nodes.MoMesh;
import com.openinventor.meshvizxlm.mapping.nodes.MoMeshSurface;
import com.openinventor.meshvizxlm.mapping.nodes.MoPredefinedColorMapping;
import com.openinventor.meshvizxlm.mapping.nodes.MoScalarSetI;
import com.openinventor.meshvizxlm.mapping.nodes.MoScalarSetIj;
import com.openinventor.meshvizxlm.mesh.cell.MiCellFilterI;
import com.openinventor.meshvizxlm.mesh.cell.MiCellFilterIj;
import com.openinventor.meshvizxlm.mesh.data.DataBinding;

import meshvizxlm.mesh.MbSampleMeshBuilder;
import meshvizxlm.mesh.data.MbScalarSetI;
import meshvizxlm.mesh.data.MbScalarSetIj;
import meshvizxlm.mesh.surfaces.MbSurfaceMeshCurvilinear;
import meshvizxlm.mesh.surfaces.MbSurfaceMeshQuadrangle;
import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private static final int NUM_CELL_I = 10;
  private static final int NUM_CELL_J = 5;
  private static final String SCALARSET_PER_NODE_NAME = "$ScalarSetX";
  private static final String SCALARSET_PER_CELL_NAME = "$CellId";
  private static final Dimension SLIDER_TEXT_DIM = new Dimension(50, 20);

  private IViewerExaminer m_renderArea;
  private MbSurfaceMeshQuadrangle m_meshSurfaceQuadrangle;
  private MbSurfaceMeshCurvilinear m_meshSurfaceCurvilinear;
  private CellFilterI m_cellFilterI;
  private CellFilterIj m_cellFilterIj;
  private MoCellFilter m_moCellFilterI;
  private MoCellFilter m_moCellFilterIj;
  private MoPredefinedColorMapping m_colMapI;
  private MoPredefinedColorMapping m_colMapIj;
  private MoScalarSetI m_moScalarSetI;
  private MoScalarSetIj m_moScalarSetIj;
  private MoCellRanges m_moCellRangesI;
  private MoCellRanges m_moCellRangesIj;

  public Main()
  {
    MbSampleMeshBuilder meshBuilder = new MbSampleMeshBuilder();

    m_meshSurfaceQuadrangle = meshBuilder.getSurfaceMeshQuadrangle(NUM_CELL_I, NUM_CELL_J, new double[] { 0, 0, 0 },
        new double[] { 100. / NUM_CELL_I, 0, 0 }, new double[] { 0, 100. / NUM_CELL_J, 0 }, null);

    m_meshSurfaceCurvilinear = meshBuilder.getSurfaceMeshCurvilinear(NUM_CELL_I, NUM_CELL_J, new double[] { 110, 0, 0 },
        new double[] { 100. / NUM_CELL_I, 0, 0 }, new double[] { 0, 100. / NUM_CELL_J, 0 });

    m_cellFilterI = new CellFilterI();
    m_cellFilterIj = new CellFilterIj();
  }

  private void setColorScalarSet(MbScalarSetI scalarSet)
  {
    m_moScalarSetI.setScalarSet(scalarSet);
    m_colMapI.minValue.setValue((float) scalarSet.getMin());
    m_colMapI.maxValue.setValue((float) scalarSet.getMax());
  }

  private void setColorScalarSet(MbScalarSetIj scalarSet)
  {
    m_moScalarSetIj.setScalarSet(scalarSet);
    m_colMapIj.minValue.setValue((float) scalarSet.getMin());
    m_colMapIj.maxValue.setValue((float) scalarSet.getMax());
  }

  private SoSeparator buildSceneGraph()
  {
    SoShapeHints sh = new SoShapeHints();
    sh.vertexOrdering.setValue(SoShapeHints.VertexOrderings.CLOCKWISE);

    // Quadrangle mesh
    MoMesh quadMoMesh = new MoMesh();
    quadMoMesh.setMesh(m_meshSurfaceQuadrangle);

    m_colMapI = new MoPredefinedColorMapping();
    m_colMapI.predefColorMap.setValue(MoPredefinedColorMapping.PredefColorMapping.STANDARD);

    m_moScalarSetI = new MoScalarSetI();

    MbScalarSetI scalarSet = m_meshSurfaceQuadrangle.getScalarSet(SCALARSET_PER_NODE_NAME);
    setColorScalarSet(scalarSet);

    m_moCellFilterI = new MoCellFilter();
    m_moCellFilterI.setCellFilter(m_cellFilterI);

    m_moCellRangesI = new MoCellRanges();

    MoMeshSurface quadrangleSurface = new MoMeshSurface();
    quadrangleSurface.colorScalarSetId.setValue(0);

    SoSeparator quadrangleSep = new SoSeparator();
    {
      quadrangleSep.addChild(quadMoMesh);
      quadrangleSep.addChild(m_colMapI);
      quadrangleSep.addChild(m_moScalarSetI);
      quadrangleSep.addChild(m_moCellFilterI);
      quadrangleSep.addChild(m_moCellRangesI);
      quadrangleSep.addChild(quadrangleSurface);
    }

    // Curvilinear mesh
    MoMesh curvMoMesh = new MoMesh();
    curvMoMesh.setMesh(m_meshSurfaceCurvilinear);

    m_colMapIj = new MoPredefinedColorMapping();
    m_colMapIj.predefColorMap.setValue(MoPredefinedColorMapping.PredefColorMapping.STANDARD);

    m_moScalarSetIj = new MoScalarSetIj();

    MbScalarSetIj scalarSetIj = m_meshSurfaceCurvilinear.getScalarSetIj(SCALARSET_PER_NODE_NAME);
    setColorScalarSet(scalarSetIj);

    m_moCellFilterIj = new MoCellFilter();
    m_moCellFilterIj.setCellFilter(m_cellFilterIj);

    m_moCellRangesIj = new MoCellRanges();
    m_moCellRangesIj.min.set1Value(0, 0);
    m_moCellRangesIj.min.set1Value(1, 0);
    m_moCellRangesIj.max.set1Value(0, NUM_CELL_I - 1);
    m_moCellRangesIj.max.set1Value(1, NUM_CELL_J - 1);

    MoMeshSurface curvilinearSurface = new MoMeshSurface();
    curvilinearSurface.colorScalarSetId.setValue(0);

    SoSeparator curvilinearSep = new SoSeparator();
    {
      curvilinearSep.addChild(curvMoMesh);
      curvilinearSep.addChild(m_colMapIj);
      curvilinearSep.addChild(m_moScalarSetIj);
      curvilinearSep.addChild(m_moCellFilterIj);
      curvilinearSep.addChild(m_moCellRangesIj);
      curvilinearSep.addChild(curvilinearSurface);
    }

    SoSeparator root = new SoSeparator();
    {
      root.addChild(sh);
      root.addChild(quadrangleSep);
      root.addChild(curvilinearSep);
    }

    return root;
  }

  private JPanel buildUI()
  {
    JPanel datasetPanel = new JPanel();
    datasetPanel
        .setBorder(new TitledBorder(new EtchedBorder(), "Dataset", TitledBorder.LEADING, TitledBorder.TOP, null, null));
    GridBagLayout gbl_datasetPanel = new GridBagLayout();
    datasetPanel.setLayout(gbl_datasetPanel);

    JRadioButton perNodeCheckBox = new JRadioButton("binded PER NODE");
    GridBagConstraints gbc_perNodeCheckBox = new GridBagConstraints();
    gbc_perNodeCheckBox.gridx = 0;
    gbc_perNodeCheckBox.gridy = 0;
    datasetPanel.add(perNodeCheckBox, gbc_perNodeCheckBox);
    perNodeCheckBox.addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent e)
      {
        MbScalarSetI scalarSet = m_meshSurfaceQuadrangle.getScalarSet(SCALARSET_PER_NODE_NAME);
        setColorScalarSet(scalarSet);

        MbScalarSetIj scalarSetIj = m_meshSurfaceCurvilinear.getScalarSetIj(SCALARSET_PER_NODE_NAME);
        setColorScalarSet(scalarSetIj);
      }
    });

    JRadioButton perCellCheckBox = new JRadioButton("binded PER CELL");
    GridBagConstraints gbc_perCellCheckBox = new GridBagConstraints();
    gbc_perCellCheckBox.weighty = 1.0;
    gbc_perCellCheckBox.anchor = GridBagConstraints.WEST;
    gbc_perCellCheckBox.weightx = 1.0;
    gbc_perCellCheckBox.gridx = 1;
    gbc_perCellCheckBox.gridy = 0;
    datasetPanel.add(perCellCheckBox, gbc_perCellCheckBox);
    perCellCheckBox.addActionListener(new ActionListener()
    {

      @Override
      public void actionPerformed(ActionEvent e)
      {
        MbScalarSetI scalarSet = m_meshSurfaceQuadrangle.getScalarSet(SCALARSET_PER_CELL_NAME);
        setColorScalarSet(scalarSet);

        MbScalarSetIj scalarSetIj = m_meshSurfaceCurvilinear.getScalarSetIj(SCALARSET_PER_CELL_NAME);
        setColorScalarSet(scalarSetIj);
      }
    });

    ButtonGroup buttonGroup = new ButtonGroup();
    buttonGroup.add(perNodeCheckBox);
    buttonGroup.add(perCellCheckBox);
    if ( m_moScalarSetI.getScalarSet() != null && m_moScalarSetI.getScalarSet().getBinding() == DataBinding.PER_NODE )
      perNodeCheckBox.setSelected(true);
    else
      perCellCheckBox.setSelected(true);

    JPanel cellFilterPanel = new JPanel();
    cellFilterPanel.setBorder(
        new TitledBorder(new EtchedBorder(), "Cell filter", TitledBorder.LEADING, TitledBorder.TOP, null, null));
    GridBagLayout gbl_cellFilterPanel = new GridBagLayout();
    cellFilterPanel.setLayout(gbl_cellFilterPanel);

    final JCheckBox cellFilterCheckBox = new JCheckBox("Cell filter");
    GridBagConstraints gbc_cellFilterCheckBox = new GridBagConstraints();
    gbc_cellFilterCheckBox.anchor = GridBagConstraints.WEST;
    gbc_cellFilterCheckBox.gridx = 0;
    gbc_cellFilterCheckBox.gridy = 0;
    gbc_cellFilterCheckBox.insets = new Insets(0, 0, 0, 15);
    cellFilterPanel.add(cellFilterCheckBox, gbc_cellFilterCheckBox);
    cellFilterCheckBox.addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent e)
      {
        if ( cellFilterCheckBox.isSelected() )
        {
          m_moCellFilterI.setCellFilter(m_cellFilterI);
          m_moCellFilterIj.setCellFilter(m_cellFilterIj);
        }
        else
        {
          m_moCellFilterI.reset();
          m_moCellFilterIj.reset();
        }
      }
    });
    if ( m_moCellFilterI.getCellFilter() != null )
      cellFilterCheckBox.setSelected(true);

    JButton modifyCellFilterButton = new JButton("Modify");
    GridBagConstraints gbc_modifyCellFilterButton = new GridBagConstraints();
    gbc_modifyCellFilterButton.anchor = GridBagConstraints.WEST;
    gbc_modifyCellFilterButton.weightx = 1.0;
    gbc_modifyCellFilterButton.gridx = 1;
    gbc_modifyCellFilterButton.gridy = 0;
    cellFilterPanel.add(modifyCellFilterButton, gbc_modifyCellFilterButton);
    modifyCellFilterButton.addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent e)
      {
        m_cellFilterI.touch();
        m_cellFilterIj.touch();
        m_moCellFilterI.touch();
        m_moCellFilterIj.touch();
      }
    });

    JPanel cellRangeIPanel = new JPanel();
    cellRangeIPanel.setBorder(
        new TitledBorder(new EtchedBorder(), "Cell range I", TitledBorder.LEADING, TitledBorder.TOP, null, null));
    cellRangeIPanel.setLayout(new GridLayout(0, 1, 0, 0));

    int initMin;
    if ( m_moCellRangesI.min.getNum() > 0 )
      initMin = (int) m_moCellRangesI.min.getValueAt(0);
    else
      initMin = 0;
    SliderPanel iMinSliderPanel = new SliderPanel(0, NUM_CELL_I * NUM_CELL_J, initMin);
    FlowLayout flowLayout = (FlowLayout) iMinSliderPanel.getLayout();
    flowLayout.setAlignment(FlowLayout.LEFT);
    iMinSliderPanel.addInfoText("I min");
    iMinSliderPanel.setInfoTextSize(SLIDER_TEXT_DIM);
    cellRangeIPanel.add(iMinSliderPanel);
    iMinSliderPanel.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        m_moCellRangesI.min.set1Value(0, (long) value);
      }
    });

    int initMax;
    if ( m_moCellRangesI.max.getNum() > 0 )
      initMax = (int) m_moCellRangesI.max.getValueAt(0);
    else
      initMax = NUM_CELL_I * NUM_CELL_J;
    SliderPanel iMaxSliderPanel = new SliderPanel(0, NUM_CELL_I * NUM_CELL_J, initMax);
    FlowLayout flowLayout_1 = (FlowLayout) iMaxSliderPanel.getLayout();
    flowLayout_1.setAlignment(FlowLayout.LEFT);
    iMaxSliderPanel.addInfoText("I max");
    iMaxSliderPanel.setInfoTextSize(SLIDER_TEXT_DIM);
    cellRangeIPanel.add(iMaxSliderPanel);
    iMaxSliderPanel.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        m_moCellRangesI.max.set1Value(0, (long) value);
      }
    });

    JPanel cellRangeIJPanel = new JPanel();
    cellRangeIJPanel.setBorder(
        new TitledBorder(new EtchedBorder(), "Cell range IJ", TitledBorder.LEADING, TitledBorder.TOP, null, null));
    cellRangeIJPanel.setLayout(new GridLayout(0, 2, 0, 0));

    if ( m_moCellRangesIj.min.getNum() > 0 )
      initMin = (int) m_moCellRangesIj.min.getValueAt(0);
    else
      initMin = 0;
    SliderPanel iMinSliderPanel2 = new SliderPanel(0, NUM_CELL_I - 1, initMin);
    FlowLayout flowLayout2 = (FlowLayout) iMinSliderPanel2.getLayout();
    flowLayout2.setAlignment(FlowLayout.LEFT);
    iMinSliderPanel2.addInfoText("I min");
    iMinSliderPanel2.setInfoTextSize(SLIDER_TEXT_DIM);
    cellRangeIJPanel.add(iMinSliderPanel2);
    iMinSliderPanel2.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        m_moCellRangesIj.min.set1Value(0, (long) value);
      }
    });

    if ( m_moCellRangesIj.max.getNum() > 0 )
      initMax = (int) m_moCellRangesIj.max.getValueAt(0);
    else
      initMax = NUM_CELL_I - 1;
    SliderPanel iMaxSliderPanel2 = new SliderPanel(0, NUM_CELL_I - 1, initMax);
    FlowLayout flowLayout3 = (FlowLayout) iMaxSliderPanel2.getLayout();
    flowLayout3.setAlignment(FlowLayout.LEFT);
    iMaxSliderPanel2.addInfoText("I max");
    iMaxSliderPanel2.setInfoTextSize(SLIDER_TEXT_DIM);
    cellRangeIJPanel.add(iMaxSliderPanel2);
    iMaxSliderPanel2.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        m_moCellRangesIj.max.set1Value(0, (long) value);
      }
    });

    if ( m_moCellRangesIj.min.getNum() > 1 )
      initMin = (int) m_moCellRangesIj.min.getValueAt(1);
    else
      initMin = 0;
    SliderPanel jMinSliderPanel2 = new SliderPanel(0, NUM_CELL_J - 1, initMin);
    FlowLayout flowLayout4 = (FlowLayout) jMinSliderPanel2.getLayout();
    flowLayout4.setAlignment(FlowLayout.LEFT);
    jMinSliderPanel2.addInfoText("J min");
    jMinSliderPanel2.setInfoTextSize(SLIDER_TEXT_DIM);
    cellRangeIJPanel.add(jMinSliderPanel2);
    jMinSliderPanel2.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        m_moCellRangesIj.min.set1Value(1, (long) value);
      }
    });

    if ( m_moCellRangesIj.max.getNum() > 1 )
      initMax = (int) m_moCellRangesIj.max.getValueAt(1);
    else
      initMax = NUM_CELL_J - 1;
    SliderPanel jMaxSliderPanel2 = new SliderPanel(0, NUM_CELL_J - 1, initMax);
    FlowLayout flowLayout5 = (FlowLayout) jMaxSliderPanel2.getLayout();
    flowLayout5.setAlignment(FlowLayout.LEFT);
    jMaxSliderPanel2.addInfoText("J max");
    jMaxSliderPanel2.setInfoTextSize(SLIDER_TEXT_DIM);
    cellRangeIJPanel.add(jMaxSliderPanel2);
    jMaxSliderPanel2.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        m_moCellRangesIj.max.set1Value(1, (long) value);
      }
    });

    JPanel panel = new JPanel();
    panel.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED, null, null));
    panel.setLayout(new GridLayout(0, 1, 0, 0));
    panel.add(datasetPanel);
    panel.add(cellFilterPanel);
    panel.add(cellRangeIPanel);
    panel.add(cellRangeIJPanel);

    return panel;
  }

  @Override
  public void start()
  {
    SoSeparator root = buildSceneGraph();

    m_renderArea = ViewerComponentsFactory.createViewerExaminer();
    m_renderArea.setSceneGraph(root);
    m_renderArea.viewAll();

    // SWING part
    JPanel panel2 = buildUI();

    final Component component = m_renderArea.getComponent();
    component.setPreferredSize(new Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
    add(panel2, BorderLayout.SOUTH);
  }

  @Override
  public void stop()
  {
    m_renderArea.dispose();
  }

  public static void main(String[] argv)
  {
    Main example = new Main();
    example.demoMain("Surface CellFilter Example");
  }

  class CellFilterI implements MiCellFilterI
  {
    private int m_v;
    private int m_ts;

    @Override
    public boolean acceptCell(long cellIndex)
    {
      if ( (cellIndex + m_v) % 3 == 0 )
        return false;
      return true;
    }

    public void touch()
    {
      m_v++;
      m_ts++;
    }

    @Override
    public long getTimeStamp()
    {
      return m_ts;
    }
  }

  class CellFilterIj implements MiCellFilterIj
  {
    private int m_v;
    private int m_ts;

    @Override
    public boolean acceptCell(long i, long j)
    {
      if ( (i + m_v) % 3 != 0 || (j + m_v) % 3 != 0 )
        return true;
      return false;
    }

    public void touch()
    {
      m_v++;
      m_ts++;
    }

    @Override
    public long getTimeStamp()
    {
      return m_ts;
    }
  }

}
