package meshvizxlm.mesh;

import com.openinventor.meshvizxlm.mesh.StorageLayoutIJK;

public class MbIjkToI
{
  private StorageLayoutIJK m_storageLayout;
  private int[] m_factor;

  /**
   * Constructor
   *
   * @param numCellI
   *          number of cells on the first axis of the input matrix.
   * @param numCellJ
   *          number of cells on the second axis of the input matrix.
   * @param numCellK
   *          number of cells on the third axis of the input matrix.
   * @param storageLayout
   *          storage layout of the mesh
   */
  public MbIjkToI(int numCellI, int numCellJ, int numCellK, StorageLayoutIJK storageLayout)
  {
    m_factor = new int[3];
    m_storageLayout = storageLayout;

    update(numCellI, numCellJ, numCellK);
  }

  public MbIjkToI(int numCellI, int numCellJ, int numCellK)
  {
    this(numCellI, numCellJ, numCellK, StorageLayoutIJK.KJI);
  }

  /**
   * Computes the index associated with the triplet (i,j,k)
   */
  public long getI(int i, int j, int k)
  {
    return i * m_factor[0] + j * m_factor[1] + k * m_factor[2];
  }

  public void update(int numCellI, int numCellJ, int numCellK)
  {
    switch ( m_storageLayout )
    {
    case IJK :
      m_factor[0] = numCellJ * numCellK;
      m_factor[1] = numCellK;
      m_factor[2] = 1;
      break;
    case IKJ :
      m_factor[0] = numCellJ * numCellK;
      m_factor[1] = 1;
      m_factor[2] = numCellJ;
      break;
    case JKI :
      m_factor[0] = 1;
      m_factor[1] = numCellI * numCellK;
      m_factor[2] = numCellI;
      break;
    case JIK :
      m_factor[0] = numCellK;
      m_factor[1] = numCellI * numCellK;
      m_factor[2] = 1;
      break;
    case UNKNOWN :
    case KJI :
      m_factor[0] = 1;
      m_factor[1] = numCellI;
      m_factor[2] = numCellI * numCellJ;
      break;
    case KIJ :
      m_factor[0] = numCellJ;
      m_factor[1] = 1;
      m_factor[2] = numCellI * numCellJ;
      break;
    }
  }

}
