package meshvizxlm.mesh;

import java.util.TreeSet;

import meshvizxlm.mesh.data.MbScalarSetI;
import meshvizxlm.mesh.data.MbVec3SetI;
import meshvizxlm.mesh.geometry.MbMeshGeometry;

import com.openinventor.meshvizxlm.mesh.MiMeshUnstructured;
import com.openinventor.meshvizxlm.mesh.data.MiVec3dSetI;

public abstract class MbMesh implements MiMeshUnstructured<MbMeshGeometry>
{

  protected MbMeshGeometry m_geometry;
  protected TreeSet<MbScalarSetI> m_scalarSets;
  protected TreeSet<MbVec3SetI> m_vec3Sets;

  public MbMesh(double[] xArray, double[] yArray, double[] zArray)
  {
    this.m_scalarSets = new TreeSet<MbScalarSetI>();
    this.m_vec3Sets = new TreeSet<MbVec3SetI>();
    this.m_geometry = new MbMeshGeometry(xArray, yArray, zArray);
  }

  @Override
  public MbMeshGeometry getGeometry()
  {
    return this.m_geometry;
  }

  public void setGeometry(double[] xArray, double[] yArray, double[] zArray)
  {
    this.m_geometry.assign(xArray, yArray, zArray);
  }

  public boolean addScalarSet(MbScalarSetI scalarSet)
  {
    return m_scalarSets.add(scalarSet);
  }

  public MbScalarSetI getScalarSet(String name)
  {
    for ( MbScalarSetI scalarSet : m_scalarSets )
    {
      int compare = scalarSet.getName().compareTo(name);
      if ( compare == 0 )
        return scalarSet;
      if ( compare > 0 )
      {
        return null;
      }
    }

    return null;
  }

  public int getNumScalarSets()
  {
    return m_scalarSets.size();
  }

  public boolean addVec3Set(MbVec3SetI vec3Set)
  {
    return m_vec3Sets.add(vec3Set);
  }

  public MiVec3dSetI getVec3Set(String name)
  {
    for ( MbVec3SetI vecSet : m_vec3Sets )
    {
      int compare = vecSet.getName().compareTo(name);
      if ( compare == 0 )
        return vecSet;
      if ( compare > 0 )
      {
        return null;
      }
    }

    return null;
  }

  public int getNumVec3Sets()
  {
    return m_vec3Sets.size();
  }

}