package meshvizxlm.mesh.cell;

import com.openinventor.meshvizxlm.extractors.cell.MxCellExtract;
import com.openinventor.meshvizxlm.extractors.cell.MxPyramidCellExtract;
import com.openinventor.meshvizxlm.mesh.cell.MiVolumeCell;
import com.openinventor.meshvizxlm.mesh.geometry.MiGeometryI;

public class MbPyramidCell implements MiVolumeCell
{
  protected static final int[][] FACET_NODE = { { 0, 1, 2, 3 }, { 0, 4, 1, -1 }, { 1, 4, 2, -1 }, { 2, 4, 3, -1 },
      { 3, 4, 0, -1 } };

  protected int[] m_nodeIds;

  public MbPyramidCell(int n0, int n1, int n2, int n3, int n4)
  {
    this.m_nodeIds = new int[5];
    this.m_nodeIds[0] = n0;
    this.m_nodeIds[1] = n1;
    this.m_nodeIds[2] = n2;
    this.m_nodeIds[3] = n3;
    this.m_nodeIds[4] = n4;
  }

  @Override
  public int[] getIsosurfTopology(int caseId, int[] edges)
  {
    return MxPyramidCellExtract.getIsosurfTopology(caseId, edges);
  }

  @Override
  public int getMarchingCaseId(boolean[] nodesSign, long beginNodeId)
  {
    byte case_id = 0;
    int bId = (int) beginNodeId;

    if ( nodesSign[this.m_nodeIds[0] - bId] )
      case_id = 1;
    if ( nodesSign[this.m_nodeIds[1] - bId] )
      case_id |= 2;
    if ( nodesSign[this.m_nodeIds[2] - bId] )
      case_id |= 4;
    if ( nodesSign[this.m_nodeIds[3] - bId] )
      case_id |= 8;
    if ( nodesSign[this.m_nodeIds[4] - bId] )
      case_id |= 16;

    if ( case_id == 31 )
      case_id = 0;
    return case_id;
  }

  @Override
  public long[] getNodesIndexOfFacet(int facet, long[] facetNodes)
  {
    switch ( facet )
    {
    case 0 :
      if ( facetNodes == null || facetNodes.length != 4 )
        facetNodes = new long[4];
      facetNodes[0] = this.m_nodeIds[FACET_NODE[facet][0]];
      facetNodes[1] = this.m_nodeIds[FACET_NODE[facet][1]];
      facetNodes[2] = this.m_nodeIds[FACET_NODE[facet][2]];
      facetNodes[3] = this.m_nodeIds[FACET_NODE[facet][3]];
      break;

    default:
      if ( facetNodes == null || facetNodes.length != 3 )
        facetNodes = new long[3];
      facetNodes[0] = this.m_nodeIds[FACET_NODE[facet][0]];
      facetNodes[1] = this.m_nodeIds[FACET_NODE[facet][1]];
      facetNodes[2] = this.m_nodeIds[FACET_NODE[facet][2]];
      break;
    }

    return facetNodes;
  }

  @Override
  public double[] getFacetCenter(int facet, MiGeometryI geometry)
  {
    int[] facetNodeInds = FACET_NODE[facet];
    double[] facetCenter = { 0, 0, 0 };
    double[] coord;
    int nbNodes;

    switch ( facet )
    {
    case 0 :
      nbNodes = 4;
      break;
    default:
      nbNodes = 3;
    }

    for ( int i = 0; i < nbNodes; ++i )
    {
      coord = geometry.getCoord(m_nodeIds[facetNodeInds[i]]);
      facetCenter[0] += coord[0];
      facetCenter[1] += coord[1];
      facetCenter[2] += coord[2];
    }

    facetCenter[0] /= nbNodes;
    facetCenter[1] /= nbNodes;
    facetCenter[2] /= nbNodes;

    return facetCenter;
  }

  @Override
  public int getNumFacets()
  {
    return 5;
  }

  @Override
  public long getNodeIndex(int node)
  {
    return this.m_nodeIds[node];
  }

  @Override
  public int getNumNodes()
  {
    return 5;
  }

  @Override
  public boolean isPointInsideCell(MiGeometryI meshGeometry, double[] pt, double[] weights)
  {
    return MxPyramidCellExtract.isPointInsideCell(meshGeometry, this, pt, weights);
  }

  @Override
  public double getRelativeSize(MiGeometryI meshGeometry)
  {
    return MxPyramidCellExtract.getLongestEdgeLength(meshGeometry, this);
  }

  @Override
  public double[] getCenter(MiGeometryI geometry)
  {
    return MxCellExtract.getCenter(geometry, this);
  }

}
