package meshvizxlm.mesh.cell;

import com.openinventor.meshvizxlm.extractors.cell.MxCellExtract;
import com.openinventor.meshvizxlm.extractors.cell.MxQuadrangleCellExtract;
import com.openinventor.meshvizxlm.mesh.cell.MiSurfaceCell;
import com.openinventor.meshvizxlm.mesh.geometry.MiGeometryI;

/**
 * Build a quadrangle cell
 *
 */
public class MbQuadrangleCell implements MiSurfaceCell
{

  private int[] m_nodeIds;

  public MbQuadrangleCell(int n0, int n1, int n2, int n3)
  {
    this.m_nodeIds = new int[4];
    this.m_nodeIds[0] = n0;
    this.m_nodeIds[1] = n1;
    this.m_nodeIds[2] = n2;
    this.m_nodeIds[3] = n3;
  }

  @Override
  public int getNumNodes()
  {
    return 4;
  }

  @Override
  public long getNodeIndex(int node)
  {
    return m_nodeIds[node];
  }

  @Override
  public double getRelativeSize(MiGeometryI meshGeometry)
  {
    return MxQuadrangleCellExtract.getLongestEdgeLength(meshGeometry, this);
  }

  @Override
  public boolean isPointInsideCell(MiGeometryI meshGeometry, double[] pt, double[] weights)
  {
    return MxQuadrangleCellExtract.isPointInsideCell(meshGeometry, this, pt, weights);
  }

  @Override
  public double[] getCenter(MiGeometryI geometry)
  {
    return MxCellExtract.getCenter(geometry, this);
  }

}
