package meshvizxlm.mesh.cell;

import com.openinventor.meshvizxlm.extractors.cell.MxCellExtract;
import com.openinventor.meshvizxlm.extractors.cell.MxTetrahedronCellExtract;
import com.openinventor.meshvizxlm.mesh.cell.MiVolumeCell;
import com.openinventor.meshvizxlm.mesh.geometry.MiGeometryI;

public class MbTetrahedronCell implements MiVolumeCell
{
  protected static final int[][] FACET_NODE = { { 0, 1, 2 }, { 0, 2, 3 }, { 0, 3, 1 }, { 1, 3, 2 } };

  protected int[] m_nodeIds;

  public MbTetrahedronCell(int nodeId0, int nodeId1, int nodeId2, int nodeId3)
  {
    this.m_nodeIds = new int[4];
    this.m_nodeIds[0] = nodeId0;
    this.m_nodeIds[1] = nodeId1;
    this.m_nodeIds[2] = nodeId2;
    this.m_nodeIds[3] = nodeId3;
  }

  @Override
  public int[] getIsosurfTopology(int caseId, int[] edges)
  {
    return MxTetrahedronCellExtract.getIsosurfTopology(caseId, edges);
  }

  @Override
  public int getMarchingCaseId(boolean[] nodesSign, long beginNodeId)
  {
    byte case_id = 0;
    int bId = (int) beginNodeId;

    if ( nodesSign[this.m_nodeIds[0] - bId] )
      case_id = 1;
    if ( nodesSign[this.m_nodeIds[1] - bId] )
      case_id |= 2;
    if ( nodesSign[this.m_nodeIds[2] - bId] )
      case_id |= 4;
    if ( nodesSign[this.m_nodeIds[3] - bId] )
      case_id |= 8;

    if ( case_id == 15 )
      case_id = 0;
    return case_id;
  }

  @Override
  public long[] getNodesIndexOfFacet(int facet, long[] facetNodes)
  {
    if ( facetNodes == null || facetNodes.length != 3 )
      facetNodes = new long[3];

    facetNodes[0] = this.m_nodeIds[FACET_NODE[facet][0]];
    facetNodes[1] = this.m_nodeIds[FACET_NODE[facet][1]];
    facetNodes[2] = this.m_nodeIds[FACET_NODE[facet][2]];

    return facetNodes;
  }

  @Override
  public double[] getFacetCenter(int facet, MiGeometryI geometry)
  {
    int[] facetNodeInds = FACET_NODE[facet];
    double[] facetCenter = { 0, 0, 0 };
    double[] coord;

    for ( int i = 0; i < 3; ++i )
    {
      coord = geometry.getCoord(m_nodeIds[facetNodeInds[i]]);
      facetCenter[0] += coord[0];
      facetCenter[1] += coord[1];
      facetCenter[2] += coord[2];
    }

    facetCenter[0] /= 3;
    facetCenter[1] /= 3;
    facetCenter[2] /= 3;

    return facetCenter;
  }

  @Override
  public int getNumFacets()
  {
    return 4;
  }

  @Override
  public long getNodeIndex(int node)
  {
    return this.m_nodeIds[node];
  }

  @Override
  public int getNumNodes()
  {
    return 4;
  }

  @Override
  public boolean isPointInsideCell(MiGeometryI meshGeometry, double[] pt, double[] weights)
  {
    return MxTetrahedronCellExtract.isPointInsideCell(meshGeometry, this, pt, weights);
  }

  @Override
  public double getRelativeSize(MiGeometryI meshGeometry)
  {
    return MxTetrahedronCellExtract.getLongestEdgeLength(meshGeometry, this);
  }

  @Override
  public double[] getCenter(MiGeometryI geometry)
  {
    return MxCellExtract.getCenter(geometry, this);
  }

}
