package meshvizxlm.mesh.data;

import com.openinventor.meshvizxlm.mesh.StorageLayoutIJK;
import com.openinventor.meshvizxlm.mesh.data.DataBinding;
import com.openinventor.meshvizxlm.mesh.data.MiVec3dSetIjk;

import meshvizxlm.mesh.MbIjkToI;

public class MbVec3SetIjk extends MbDataSet implements MiVec3dSetIjk
{
  protected static int s_numInstance = 0;

  private double[] m_xArray;
  private double[] m_yArray;
  private double[] m_zArray;
  protected MbIjkToI m_adaptor;
  protected int m_numI;
  protected int m_numJ;
  protected int m_numK;

  public MbVec3SetIjk(int numI, int numJ, int numK, String name, DataBinding binding)
  {
    super(name, binding);

    s_numInstance++;

    m_adaptor = new MbIjkToI(numI, numJ, numK);
    m_numI = numI;
    m_numJ = numJ;
    m_numK = numK;

    final int size = m_numI * m_numJ * m_numK;
    m_xArray = new double[size];
    m_yArray = new double[size];
    m_zArray = new double[size];
  }

  public MbVec3SetIjk(int numI, int numJ, int numK)
  {
    super();

    m_name = "MbVec3Set_#" + s_numInstance;
    s_numInstance++;

    m_adaptor = new MbIjkToI(numI, numJ, numK);
    m_numI = numI;
    m_numJ = numJ;
    m_numK = numK;

    final int size = m_numI * m_numJ * m_numK;
    m_xArray = new double[size];
    m_yArray = new double[size];
    m_zArray = new double[size];
  }

  @Override
  public double[] get(int i, int j, int k)
  {
    int index = (int) m_adaptor.getI(i, j, k);
    return new double[] { m_xArray[index], m_yArray[index], m_zArray[index] };
  }

  @Override
  public StorageLayoutIJK getStorageLayout()
  {
    return StorageLayoutIJK.UNKNOWN;
  }

  public void set(int i, int j, int k, double x, double y, double z)
  {
    if ( i < m_numI && j < m_numJ && k < m_numK )
    {
      int index = (int) m_adaptor.getI(i, j, k);
      m_xArray[index] = x;
      m_yArray[index] = y;
      m_zArray[index] = z;
      touch();
    }
  }

  public int[] getSize(int[] size)
  {
    if ( size == null )
      size = new int[3];
    size[0] = m_numI;
    size[1] = m_numJ;
    size[2] = m_numK;

    return size;
  }

  public void setSize(int numI, int numJ, int numK)
  {
    m_adaptor.update(numI, numJ, numK);

    m_numI = numI;
    m_numJ = numJ;
    m_numK = numK;

    final int size = m_numI * m_numJ * m_numK;
    m_xArray = new double[size];
    m_yArray = new double[size];
    m_zArray = new double[size];
    touch();
  }

}
