package meshvizxlm.mesh.geometry;

import com.openinventor.meshvizxlm.MxTimeStamp;
import com.openinventor.meshvizxlm.mesh.CellStorageLayout;
import com.openinventor.meshvizxlm.mesh.MiVolumeMeshHexahedronIjk;
import com.openinventor.meshvizxlm.mesh.StorageLayoutIJK;
import com.openinventor.meshvizxlm.mesh.geometry.MiGeometryHexahedronIjk;

import meshvizxlm.mesh.topology.MbHexahedronTopologyExplicitIjk;

public class MbGeometryHexahedronIjk implements MiGeometryHexahedronIjk
{

  private MbHexahedronTopologyExplicitIjk m_topology;
  private MbMeshGeometry m_geometry;
  private long m_timeStamp;

  public MbGeometryHexahedronIjk(MiVolumeMeshHexahedronIjk<MbHexahedronTopologyExplicitIjk, MbMeshGeometry> hexaIjkMesh)
  {
    m_topology = hexaIjkMesh.getTopology();
    m_geometry = hexaIjkMesh.getGeometry();
    m_timeStamp = MxTimeStamp.getTimeStamp();
  }

  @Override
  public long getTimeStamp()
  {
    return m_timeStamp;
  }

  @Override
  public void getCellCoords(int i, int j, int k, double[] cellCoords)
  {
    int index = (int) m_topology.getAdaptor().getI(i, j, k) * 8;
    int[] indices = m_topology.getIndices();

    int nodeId;
    for ( int n = 0, c = 0; n < 8; n++ )
    {
      nodeId = indices[index + n];
      cellCoords[c++] = m_geometry.m_xArray[nodeId];
      cellCoords[c++] = m_geometry.m_yArray[nodeId];
      cellCoords[c++] = m_geometry.m_zArray[nodeId];
    }
  }

  @Override
  public StorageLayoutIJK getStorageLayout()
  {
    return m_topology.getStorageLayout();
  }

  @Override
  public CellStorageLayout getCellStorageLayout()
  {
    return CellStorageLayout.K_MIN_FIRST;
  }

  public void touch()
  {
    m_timeStamp = MxTimeStamp.getTimeStamp();
  }

}
