package meshvizxlm.mesh.geometry;

import java.util.Arrays;

import com.openinventor.meshvizxlm.mesh.geometry.MiGeometryI;

public class MbMeshGeometry extends MbGeometry implements MiGeometryI
{
  protected double[] m_xArray;
  protected double[] m_yArray;
  protected double[] m_zArray;
  private double[] m_min;
  private double[] m_max;
  private boolean m_minMaxUpToDate;

  public MbMeshGeometry(double[] xArray, double[] yArray, double[] zArray)
  {
    m_xArray = xArray;
    m_yArray = yArray;
    m_zArray = zArray;
    m_min = new double[3];
    m_max = new double[3];
    m_minMaxUpToDate = false;
  }

  public void assign(double[] xArray, double[] yArray, double[] zArray)
  {
    m_xArray = xArray;
    m_yArray = yArray;
    m_zArray = zArray;

    touch();
  }

  public void setX(long i, double x)
  {
    m_xArray[(int) i] = x;
  }

  public void setY(long i, double y)
  {
    m_yArray[(int) i] = y;
  }

  public void setZ(long i, double z)
  {
    m_zArray[(int) i] = z;
  }

  @Override
  public void touch()
  {
    super.touch();
    m_minMaxUpToDate = false;
  }

  @Override
  public double[] getCoord(long i)
  {
    return new double[] { m_xArray[(int) i], m_yArray[(int) i], m_zArray[(int) i] };
  }

  public double getXMax()
  {
    updateMinMax();
    return m_max[0];
  }

  public double getYMax()
  {
    updateMinMax();
    return m_max[1];
  }

  public double getZMax()
  {
    updateMinMax();
    return m_max[2];
  }

  public double getXMin()
  {
    updateMinMax();
    return m_min[0];
  }

  public double getYMin()
  {
    updateMinMax();
    return m_min[1];
  }

  public double getZMin()
  {
    updateMinMax();
    return m_min[2];
  }

  private void updateMinMax()
  {
    if ( !m_minMaxUpToDate )
    {
      Arrays.fill(m_min, Double.POSITIVE_INFINITY);
      Arrays.fill(m_max, Double.NEGATIVE_INFINITY);

      for ( int i = 0; i < m_xArray.length; i++ )
      {
        if ( m_xArray[i] < m_min[0] )
          m_min[0] = m_xArray[i];
        if ( m_xArray[i] > m_max[0] )
          m_max[0] = m_xArray[i];

        if ( m_yArray[i] < m_min[1] )
          m_min[1] = m_yArray[i];
        if ( m_yArray[i] > m_max[1] )
          m_max[1] = m_yArray[i];

        if ( m_zArray[i] < m_min[2] )
          m_min[2] = m_zArray[i];
        if ( m_zArray[i] > m_max[2] )
          m_max[2] = m_zArray[i];
      }
      m_minMaxUpToDate = true;
    }
  }
}
