package meshvizxlm.mesh.surfaces;

import java.util.TreeSet;

import meshvizxlm.mesh.data.MbScalarSetIj;
import meshvizxlm.mesh.data.MbVec3SetIj;
import meshvizxlm.mesh.topology.MbTopologyIj;

public class MbMeshIj
{
  protected MbTopologyIj m_topology;
  protected TreeSet<MbScalarSetIj> m_scalarSets;
  protected TreeSet<MbVec3SetIj> m_vec3Sets;

  public MbMeshIj(int numCellI, int numCellJ)
  {
    m_topology = new MbTopologyIj(numCellI, numCellJ);
    m_scalarSets = new TreeSet<MbScalarSetIj>();
    m_vec3Sets = new TreeSet<MbVec3SetIj>();
  }

  public void setDeadCell(long i, long j, boolean isDead)
  {
    m_topology.setDeadFlag(i, j, isDead);
  }

  public boolean addScalarSetIj(MbScalarSetIj scalarSet)
  {
    return m_scalarSets.add(scalarSet);
  }

  public boolean addVec3SetIj(MbVec3SetIj vectorSet)
  {
    return m_vec3Sets.add(vectorSet);
  }

  public MbScalarSetIj getScalarSetIj(String name)
  {
    for ( MbScalarSetIj scalarSet : m_scalarSets )
    {
      int compare = scalarSet.getName().compareTo(name);
      if ( compare == 0 )
        return scalarSet;
      if ( compare > 0 )
      {
        return null;
      }
    }

    return null;
  }

  public MbVec3SetIj getVec3SetIj(String name)
  {
    for ( MbVec3SetIj vectorSet : m_vec3Sets )
    {
      int compare = vectorSet.getName().compareTo(name);
      if ( compare == 0 )
        return vectorSet;
      if ( compare > 0 )
      {
        return null;
      }
    }

    return null;
  }

  public int getNumScalarSetsIj()
  {
    return m_scalarSets.size();
  }

  public int getNumVec3SetsIj()
  {
    return m_vec3Sets.size();
  }

}
