package meshvizxlm.mesh.topology;

import java.util.ArrayList;
import java.util.List;

import meshvizxlm.mesh.cell.MbPyramidCell;

public class MbPyramidCellsSet extends MbTopologyI<MbPyramidCell>
{

  protected List<MbPyramidCell> m_cells;
  protected int m_beginNodeId;
  protected int m_endNodeId;

  public MbPyramidCellsSet()
  {
    this.m_beginNodeId = 0;
    this.m_endNodeId = 0;
    this.m_cells = new ArrayList<MbPyramidCell>();
  }

  @Override
  public MbPyramidCell getCell(long id)
  {
    return this.m_cells.get((int) id);
  }

  @Override
  public long getBeginNodeId()
  {
    return m_beginNodeId;
  }

  @Override
  public long getEndNodeId()
  {
    return m_endNodeId;
  }

  @Override
  public long getNumCells()
  {
    return this.m_cells.size();
  }

  @Override
  protected void assign(NodeIdProvider provider)
  {
    this.m_cells.clear();
    this.m_beginNodeId = Integer.MAX_VALUE;
    this.m_endNodeId = 0;

    final int numNodes = 5;
    final int numCells = provider.size() / numNodes;
    int[] node = new int[numNodes];

    for ( int iCell = 0, iNode = 0; iCell < numCells; ++iCell )
    {
      for ( int i = 0; i < numNodes; ++i, ++iNode )
      {
        node[i] = provider.get(iNode);

        if ( node[i] + 1 > this.m_endNodeId )
          m_endNodeId = node[i] + 1;
        if ( node[i] < this.m_beginNodeId )
          m_beginNodeId = node[i];
      }

      this.m_cells.add(new MbPyramidCell(node[0], node[1], node[2], node[3], node[4]));
    }
  }
}
