package meshvizxlm.mesh.topology;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

import com.openinventor.meshvizxlm.MxTimeStamp;
import com.openinventor.meshvizxlm.mesh.topology.MiSurfaceTopologyExplicitI;

import meshvizxlm.mesh.cell.MbQuadrangleCell;

/**
 * Build a quadrangle cell set
 *
 */
public class MbQuadrangleCellsSet implements MiSurfaceTopologyExplicitI<MbQuadrangleCell>
{

  protected List<MbQuadrangleCell> m_cells;
  protected int m_beginNodeId;
  protected int m_endNodeId;

  protected long m_timeStamp;
  protected BitSet m_deadCells;

  public MbQuadrangleCellsSet()
  {
    m_beginNodeId = 0;
    m_endNodeId = 0;
    m_cells = new ArrayList<MbQuadrangleCell>();
    m_timeStamp = MxTimeStamp.getTimeStamp();
  }

  @Override
  public MbQuadrangleCell getCell(long id)
  {
    return m_cells.get((int) id);
  }

  @Override
  public long getBeginNodeId()
  {
    return m_beginNodeId;
  }

  @Override
  public long getEndNodeId()
  {
    return m_endNodeId;
  }

  @Override
  public long getNumCells()
  {
    return m_cells.size();
  }

  public void assign(int... nodeIds)
  {
    this.m_cells.clear();
    this.m_beginNodeId = Integer.MAX_VALUE;
    this.m_endNodeId = 0;

    final int numNodes = 4;
    int[] cellNodes = new int[numNodes];
    int nodeId;
    int iCellNodes;

    for ( int i = 0; i < nodeIds.length; i++ )
    {
      nodeId = nodeIds[i];

      if ( nodeId + 1 > m_endNodeId )
        m_endNodeId = nodeId + 1;
      if ( nodeId < m_beginNodeId )
        m_beginNodeId = nodeId;

      iCellNodes = i % numNodes;
      cellNodes[iCellNodes] = nodeId;

      if ( iCellNodes == numNodes - 1 )
        m_cells.add(new MbQuadrangleCell(cellNodes[0], cellNodes[1], cellNodes[2], cellNodes[3]));
    }
    touch();
  }

  @Override
  public long getTimeStamp()
  {
    return m_timeStamp;
  }

  public void touch()
  {
    this.m_timeStamp = MxTimeStamp.getTimeStamp();
  }

  @Override
  public boolean hasDeadCells()
  {
    return null != m_deadCells && !m_deadCells.isEmpty();
  }

  @Override
  public boolean isDead(long i)
  {
    return m_deadCells.get((int) i);
  }

  public void assignDeadFlags(boolean[] flags)
  {
    m_deadCells = new BitSet(flags.length);
    int i = 0;

    for ( boolean flag : flags )
    {
      m_deadCells.set(i, flag);
      i++;
    }
    m_timeStamp = MxTimeStamp.getTimeStamp();
  }

}
