package meshvizxlm.mesh.volumes;

import java.util.TreeSet;

import meshvizxlm.mesh.data.MbScalarSetIjk;
import meshvizxlm.mesh.data.MbVec3SetIjk;

public class MbMeshIjk
{

  protected TreeSet<MbScalarSetIjk> m_scalarSets;
  protected TreeSet<MbVec3SetIjk> m_vec3Sets;

  public MbMeshIjk()
  {
    m_scalarSets = new TreeSet<MbScalarSetIjk>();
    m_vec3Sets = new TreeSet<MbVec3SetIjk>();
  }

  public boolean addScalarSetIjk(MbScalarSetIjk scalarSet)
  {
    return m_scalarSets.add(scalarSet);
  }

  public boolean addVec3SetIjk(MbVec3SetIjk vectorSet)
  {
    return m_vec3Sets.add(vectorSet);
  }

  public MbScalarSetIjk getScalarSetIjk(String name)
  {
    for ( MbScalarSetIjk scalarSet : m_scalarSets )
    {
      int compare = scalarSet.getName().compareTo(name);
      if ( compare == 0 )
        return scalarSet;
      if ( compare > 0 )
      {
        return null;
      }
    }

    return null;
  }

  public MbVec3SetIjk getVec3SetIjk(String name)
  {
    for ( MbVec3SetIjk vectorSet : m_vec3Sets )
    {
      int compare = vectorSet.getName().compareTo(name);
      if ( compare == 0 )
        return vectorSet;
      if ( compare > 0 )
      {
        return null;
      }
    }

    return null;
  }

  public int getNumScalarSetsIjk()
  {
    return m_scalarSets.size();
  }

  public int getNumVec3SetsIjk()
  {
    return m_vec3Sets.size();
  }

}
