package meshvizxlm.mesh.volumes;

import java.util.ArrayList;
import java.util.List;

import meshvizxlm.mesh.cell.MbPolyhedricCell;
import meshvizxlm.mesh.topology.MbPolyhedronCellsSet;

import com.openinventor.meshvizxlm.mesh.topology.MiVolumeTopologyExplicitI;

public class MbVolumeMeshPolyhedron extends MbVolumeMeshUnstructured<MbPolyhedricCell>
{
  protected MbPolyhedronCellsSet m_topology;

  public MbVolumeMeshPolyhedron(double[] xArray, double[] yArray, double[] zArray, MbPolyhedricCell... polyhedricCells)
  {
    super(xArray, yArray, zArray);

    m_topology = new MbPolyhedronCellsSet();
    setTopology(polyhedricCells);
  }

  public MbVolumeMeshPolyhedron(double[] xArray, double[] yArray, double[] zArray, int[] faceNodeList,
      int[] numNodePerFaceList, List<ArrayList<Integer>> cellFacets, int numCells)
  {
    super(xArray, yArray, zArray);

    m_topology = new MbPolyhedronCellsSet();
    m_topology.assign(faceNodeList, numNodePerFaceList, cellFacets, numCells);
  }

  public void setTopology(MbPolyhedricCell... polyhedricCells)
  {
    m_topology.assign(polyhedricCells);
  }

  public void setDeadCells(boolean[] flags)
  {
    m_topology.assignDeadFlags(flags);
  }

  public int getNumNodes()
  {
    return (int) m_topology.getEndNodeId();
  }

  @Override
  public MiVolumeTopologyExplicitI<MbPolyhedricCell> getTopology()
  {
    return m_topology;
  }
}
