package meshvizxlm.mesh.volumes;

import java.util.List;

import meshvizxlm.mesh.cell.MbPyramidCell;
import meshvizxlm.mesh.topology.MbPyramidCellsSet;

import com.openinventor.meshvizxlm.mesh.topology.MiVolumeTopologyExplicitI;

public class MbVolumeMeshPyramid extends MbVolumeMeshUnstructured<MbPyramidCell>
{

  protected MbPyramidCellsSet m_topology;

  public MbVolumeMeshPyramid(double[] xArray, double[] yArray, double[] zArray, List<Integer> nodeIds)
  {
    super(xArray, yArray, zArray);

    this.m_topology = new MbPyramidCellsSet();
    setTopology(nodeIds);
  }

  public MbVolumeMeshPyramid(double[] xArray, double[] yArray, double[] zArray, int... nodeIds)
  {
    super(xArray, yArray, zArray);

    this.m_topology = new MbPyramidCellsSet();
    setTopology(nodeIds);
  }

  @Override
  public MiVolumeTopologyExplicitI<MbPyramidCell> getTopology()
  {
    return this.m_topology;
  }

  public void setTopology(List<Integer> nodeIds)
  {
    this.m_topology.assign(nodeIds);
  }

  public void setTopology(int... nodeIds)
  {
    this.m_topology.assign(nodeIds);
  }

}
