package remoteviz.clientworkbench.clientworkbenchrenderingservice;

import com.openinventor.remoteviz.rendering.Connection;
import com.openinventor.remoteviz.rendering.RenderArea;
import com.openinventor.remoteviz.rendering.RenderAreaListener;
import com.openinventor.remoteviz.rendering.KeepFrameQualityPolicy;
import com.openinventor.remoteviz.rendering.KeepFramesPerSecondPolicy;

public class ClientWorkbenchRenderArea extends RenderAreaListener
{

  @Override
  public void onReceivedMessage(RenderArea renderArea, Connection sender, String message)
  {
    String[] elems = message.split(" "); // split the received message, pattern
                                         // : "COMMAND ARGUMENT"
    if ( elems.length == 2 )
    {
      String command = elems[0];
      String argument = elems[1];

      // parse the commands
      if ( command.equals("POLICY") )
      {
        if ( argument.equals("KeepFrameQuality") )
          sender.getSettings().setFrameEncodingPolicy(new KeepFrameQualityPolicy());
        else if ( argument.equals("KeepFramesPerSecond") )
          sender.getSettings().setFrameEncodingPolicy(new KeepFramesPerSecondPolicy());
      }
      else if ( command.equals("BANDWIDTH") )
      {
        sender.getClient().getSettings().setBandwidth(Integer.parseInt(argument));
      }
      else if ( command.equals("WIDTH") )
      {
        renderArea.resize(Integer.parseInt(argument), renderArea.getSceneManager().getSize().getY());
      }
      else if ( command.equals("HEIGHT") )
      {
        renderArea.resize(renderArea.getSceneManager().getSize().getX(), Integer.parseInt(argument));
      }
    }
    else
    {
      System.out.println("Error in received command (unrecognized message: " + message + ")");
    }
  }

}
