package remoteviz.frontbacksync.frontbacksyncrenderingservice;

import com.openinventor.inventor.SbMatrix;
import com.openinventor.inventor.actions.SoAction;
import com.openinventor.inventor.actions.SoGetBoundingBoxAction;
import com.openinventor.inventor.elements.SoModelMatrixElement;
import com.openinventor.inventor.elements.SoProjectionMatrixElement;
import com.openinventor.inventor.elements.SoViewingMatrixElement;
import com.openinventor.inventor.misc.SoState;
import com.openinventor.inventor.nodes.SoAlgebraicCone;
import com.openinventor.inventor.nodes.SoAnnoText3;
import com.openinventor.inventor.nodes.SoAnnoText3Property;
import com.openinventor.inventor.nodes.SoAnnotation;
import com.openinventor.inventor.nodes.SoCallback;
import com.openinventor.inventor.nodes.SoFont;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoTransform;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.inventor.viewercomponents.nodes.SceneInteractor.CameraMode;
import com.openinventor.remoteviz.rendering.RenderArea;
import com.openinventor.remoteviz.rendering.Service;
import com.openinventor.remoteviz.rendering.ServiceListener;
import com.openinventor.remoteviz.rendering.ServiceSettings;

public class FrontBackSyncService extends ServiceListener
{

  private static boolean running = true;
  private static final Thread mainThread = Thread.currentThread();

  /**
   * @param args
   * @throws InterruptedException
   */
  public static void main(String[] args)
  {
    // Default value for service IP address
    String serviceIPaddress = "127.0.0.1";
    // Default value for service port
    int servicePort = 8080;

    // Use passed values for the service IP address and port
    if ( args.length == 2 )
    {
      serviceIPaddress = args[0];
      servicePort = Integer.parseInt(args[1]);
    }

    // Instantiate a service settings class
    ServiceSettings settings = new ServiceSettings();
    // set the IP address used by the service
    settings.setIP(serviceIPaddress);
    // set the port used by the service
    settings.setPort(servicePort);

    // Add a BasicJQueryGuiService class as listener
    Service.instance().addListener(new FrontBackSyncService());

    // Open the service by using the settings
    if ( Service.instance().open(settings) )
    {
      Runtime.getRuntime().addShutdownHook(new Thread()
      {
        @Override
        public void run()
        {
          try
          {
            running = false;
            mainThread.join();
          }
          catch (InterruptedException e)
          {}
        }
      });

      System.out.println("The SynchronizedFrontend Rendering Service is running. Press Ctrl + C to stop.");
      try
      {
        // Main loop
        while ( running )
        {
          Service.instance().dispatch();
          Thread.sleep(1);
        }
      }
      catch (InterruptedException ex)
      {}
      finally
      {
        // Close the service
        Service.instance().close();
      }
    }

  }

  @Override
  public void onInstantiatedRenderArea(RenderArea renderArea)
  {
    FrontBackSyncRenderArea fbs = new FrontBackSyncRenderArea();
    renderArea.addListener(fbs);
    renderArea.getTouchManager().addDefaultRecognizers();

    SceneExaminer sceneExaminer = new SceneExaminer();
    sceneExaminer.setNavigationMode(NavigationMode.ORBIT);
    sceneExaminer.setCameraMode(CameraMode.ORTHOGRAPHIC);

    SoAlgebraicCone cone = new SoAlgebraicCone();
    sceneExaminer.addChild( cone );

    SoTransform transform = new SoTransform();
    transform.translation.setValue( -0.5f, -1.3f, 0.f );

    SoAnnoText3Property annoText3Property = new SoAnnoText3Property();
    annoText3Property.renderPrintType.setValue(SoAnnoText3Property.RenderPrintTypes.RENDER2D_PRINT_RASTER);

    SoMaterial mat = new SoMaterial();
    mat.diffuseColor.setValue(0.98f, 0.68f, 0.27f);

    SoCallback callbackNode = new SoCallback();
    callbackNode.setCallback(
        new SoCallback.CB()
        {

          @Override
          public void invoke(SoAction action)
          {
            if(action instanceof SoGetBoundingBoxAction )
            {
              SoState state = action.getState();
              SbMatrix M =  SoModelMatrixElement.get(state);
              M.multRight(SoViewingMatrixElement.get(state));
              M.multRight(SoProjectionMatrixElement.get(state));
              fbs.setM_mvp(M);
            }
          }
        }
    );
    sceneExaminer.addChild(callbackNode);

    SoFont font = new SoFont();
    font.size.setValue(0.2f);
    font.name.setValue("Arial");

    SoAnnoText3 textBack = new SoAnnoText3();
    textBack.string.set1Value( 0, "Cone drawn" );
    textBack.string.set1Value( 1, "on backend" );

    SoAnnotation legendAnnot = new SoAnnotation() ;

    sceneExaminer.addChild( transform );
    sceneExaminer.addChild( legendAnnot );
    legendAnnot.addChild( annoText3Property );
    legendAnnot.addChild( mat );
    legendAnnot.addChild( font );
    legendAnnot.addChild( textBack );

    renderArea.getSceneManager().setSceneGraph(sceneExaminer);
    sceneExaminer.viewAll(renderArea.getSceneManager().getViewportRegion());

  }
}
