package remoteviz.helloconeVP9.helloconevp9renderingservice;

import com.openinventor.remoteviz.rendering.Connection;
import com.openinventor.remoteviz.rendering.FrameEncoders;
import com.openinventor.remoteviz.rendering.FrameEncoders.Encoders;
import com.openinventor.remoteviz.rendering.RenderArea;
import com.openinventor.remoteviz.rendering.RenderAreaListener;

public class HelloConeVP9RenderAreaListener extends RenderAreaListener
{

  @Override
  public void onOpenedConnection(RenderArea renderArea, Connection connection, FrameEncoders frameEncoders)
  {
    frameEncoders.setInteractiveEncoder(Encoders.VP9_VPX);
    frameEncoders.setStillEncoder(Encoders.VP9_VPX);
  }

  @Override
  public void onInitializedConnection(RenderArea renderArea, Connection sender, FrameEncoders frameEncoders)
  {
    if ( frameEncoders.getInteractiveEncoder() == Encoders.JPEG && frameEncoders.getStillEncoder() == Encoders.JPEG )
    {
      System.out.println("New connection using JPEG encoder for interactive and still frames.");
    }
    else if ( frameEncoders.getInteractiveEncoder() == Encoders.JPEG && frameEncoders.getStillEncoder() == Encoders.PNG )
    {
      System.out.println("New connection using JPEG encoder for interactive frames and PNG encoder for still frames.");
    }
    else if ( frameEncoders.getInteractiveEncoder() == Encoders.VP9_VPX && frameEncoders.getStillEncoder() == Encoders.VP9_VPX )
    {
      System.out.println("New connection using VPX encoder (CPU encoding) for interactive and still frames.");
    }
    else
    {
      System.out.println("New connection.");
    }
  }

  @Override
  public void onRefusedEncoder(RenderArea renderArea, Connection sender, FrameEncoders frameEncoders)
  {
    if( frameEncoders.getInteractiveEncoder() == Encoders.VP9_VPX && frameEncoders.getStillEncoder() == Encoders.VP9_VPX )
    {
      frameEncoders.setInteractiveEncoder(Encoders.JPEG);
      frameEncoders.setStillEncoder(Encoders.PNG);
    }
    else if( frameEncoders.getInteractiveEncoder() == Encoders.JPEG && frameEncoders.getStillEncoder() == Encoders.PNG )
    {
      frameEncoders.setInteractiveEncoder(Encoders.JPEG);
      frameEncoders.setStillEncoder(Encoders.JPEG);
    }
    else if( frameEncoders.getInteractiveEncoder() == Encoders.JPEG && frameEncoders.getStillEncoder() == Encoders.JPEG )
    {
      System.out.println("Error: RemoteViz codec libraries are missing.");
      sender.close();
    }
    else
    {
      frameEncoders.setInteractiveEncoder(Encoders.JPEG);
      frameEncoders.setStillEncoder(Encoders.JPEG);
    }
  }
}
