package remoteviz.independentservice.independentrenderingservice;

import com.jogamp.opengl.GLProfile;

import com.openinventor.remoteviz.rendering.RenderArea;
import com.openinventor.remoteviz.rendering.Service;
import com.openinventor.remoteviz.rendering.ServiceListener;
import com.openinventor.remoteviz.rendering.ServiceSettings;

public class IndependentService extends ServiceListener
{

  private static boolean running = true;
  private static final Thread mainThread = Thread.currentThread();

  /**
   * @param args
   * @throws InterruptedException
   */
  public static void main(String[] args)
  {
    // Instantiates singleton GLProfile objects
    GLProfile.getDefault();

    // Default value for service IP address
    String serviceIPaddress = "127.0.0.1";
    // Default value for service port
    int servicePort = 8080;

    // Use passed values for the service IP address and port
    if ( args.length == 2 )
    {
      serviceIPaddress = args[0];
      servicePort = Integer.parseInt(args[1]);
    }

    // Instantiate a service settings class
    ServiceSettings settings = new ServiceSettings();
    // set the IP address used by the service
    settings.setIP(serviceIPaddress);
    // set the port used by the service
    settings.setPort(servicePort);

    // set the run mode used by the service
    settings.setRunMode(ServiceSettings.RunModes.INDEPENDENT_SERVICE);

    // Add a IndependentService class as listener
    Service.instance().addListener(new IndependentService());

    // To use an Open Inventor extension with RemoteViz, uncomment the following
    // line and set the extension name.
    // settings.setUsedExtensions(ServiceSettings.Extensions.VOLUMEVIZLDM);

    // Open the service by using the settings
    if ( Service.instance().open(settings) )
    {
      Runtime.getRuntime().addShutdownHook(new Thread()
      {
        public void run()
        {
          try
          {
            running = false;
            mainThread.join();
          }
          catch (InterruptedException e)
          {}
        }
      });

      System.out.println("The Independent Engine Rendering Service is running. Press Ctrl + C to stop.");

      try
      {
        // Main loop
        while ( running )
        {
          Service.instance().dispatch();
          Thread.sleep(1);
        }
      }
      catch (InterruptedException ex)
      {}
      finally
      {
        // Close the service
        Service.instance().close();
      }
    }
  }

  @Override
  /**
   * Triggered when a renderArea has been instantiated.
   */
  public void onInstantiatedRenderArea(RenderArea renderArea)
  {
    renderArea.addListener(new IndependentRenderArea(renderArea));
  }
}
