package remoteviz.loadbalancing.loadbalancedrenderingservice;

import java.net.URI;
import org.json.JSONObject;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.ContentType;
import org.apache.commons.io.IOUtils;

import remoteviz.loadbalancing.loadbalancedrenderingservice.Instance;

public class LoadBalancerClient
{
  private static final String registrationApiIP = "127.0.0.1";
  private static final short registrationApiPort = 8081;
  private static final HttpClient httpClient = HttpClientBuilder.create().build();

  /**
   *
   *  Register the instance to the load balancer from its IP address and its port number.
   *
   *  \param instance : instance to register (instance.id will be modified to match returned id).
   */
  public static boolean registerInstance(Instance instance)
  {
    JSONObject jsonInstance = new JSONObject(instance);    
    StringEntity requestEntity = new StringEntity(jsonInstance.toString(), ContentType.APPLICATION_JSON);

    try
    {
      URI instanceRegistrationUrl = new URI("http", null, registrationApiIP, registrationApiPort, "/instance", null, null);
      HttpPost postMethod = new HttpPost(instanceRegistrationUrl);
      postMethod.setEntity(requestEntity);
      HttpResponse response = httpClient.execute(postMethod);
      int statusCode = response.getStatusLine().getStatusCode();
      String responseContent = IOUtils.toString(response.getEntity().getContent(), "UTF-8"); 
      if (statusCode == 200)
      {
        JSONObject responseContentJson = new JSONObject(responseContent);
        instance.setId(responseContentJson.getInt("id"));
        return true;
      }
      else // message error
      {
        System.out.println("Unable to register the instance to the load balancer:");
        System.out.printf("Error code: %d\n", statusCode);
        System.out.printf("Message: %s\n", responseContent);
        return false;
      }
    }
    catch (Exception e)
    {
      // Connection error
      System.out.println("Unable to establish connection with the load balancer.");
      return false;
    }
  }

  /**
   *
   *  Unregister the instance to the load balancer from its ID.
   *
   *  \param instance : Instance to unregister.
   */
  public static boolean unregisterInstance(Instance instance)
  {
    try
    {
      URI instanceUnregistrationUrl = new URI("http", null, registrationApiIP, registrationApiPort, "/instance/" + instance.getId(), null, null);
      HttpDelete deleteMethod = new HttpDelete(instanceUnregistrationUrl);
      HttpResponse response = httpClient.execute(deleteMethod);
      int statusCode = response.getStatusLine().getStatusCode();
      String responseContent = IOUtils.toString(response.getEntity().getContent(), "UTF-8");
      if (statusCode != 200)
      {
        System.out.println("Error when unregistering the instance to the load balancer:");
        System.out.printf("Error code: %d\n", statusCode);
        System.out.printf("Message: %s\n", responseContent);
        return false;
      }
    }
    catch (Exception e)
    {
      // Connection error
      System.out.println("Unable to establish connection with the load balancer.");
      return false;
    }
    return true;
  }

  /**
   *
   *  Delete the renderArea to the load balancer from its ID.
   *
   *  \param renderAreaId : ID identifying the renderArea
   */
  public static boolean deleteRenderArea(String renderAreaId)
  {
    try
    {
      URI renderAreaDeleteUrl = new URI("http", null, registrationApiIP, registrationApiPort, "/renderArea/" + renderAreaId, null, null);
      HttpDelete deleteMethod = new HttpDelete(renderAreaDeleteUrl);
      HttpResponse response = httpClient.execute(deleteMethod);
      int statusCode = response.getStatusLine().getStatusCode();
      String responseContent = IOUtils.toString(response.getEntity().getContent(), "UTF-8");
      if (statusCode != 200)
      {
        System.out.println("Error when deleting the renderArea to the load balancer:");
        System.out.printf("Error code: %d\n", statusCode);
        System.out.printf("Message: %s\n", responseContent);
        return false;
      }
    }
    catch (Exception e)
    {
      // Connection error
      System.out.println("Unable to establish connection with the load balancer.");
      return false;
    }
    return true;
  }
}
