// Web Server serving static files over HTTP

var express = require('express'),
    app = express(),
    http = require('http');

http.Server(app);

app.use(express.static(__dirname + '/../Clients/HTML5'));

app.get('/', function (req, res) {
    res.sendFile(__dirname + '/../Clients/HTML5/index.html');
});

// Load configuration file that stores IP address and port number.
const config = require('./config/config.json');
const webServerConfig = config.webserver;

app.listen(webServerConfig.port, webServerConfig.ip, () => {
    console.log(`Web server running at http://${webServerConfig.ip}:${webServerConfig.port}/`);
});
