package remoteviz.remotevizclientnode;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import com.openinventor.inventor.SbEventListener;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.viewercomponents.awt.glcanvas.renderareas.RenderAreaExaminer;
import com.openinventor.remoteviz.clients.nodes.SoRemoteVizClient;
import com.openinventor.remoteviz.clients.nodes.SoRemoteVizClient.ServiceMessageEventArg;

public class RemoteVizClientNode extends Panel
{

  private static final short HEIGHT = 480;
  private static final short WIDTH = 640;

  private ServiceMessageListener serviceMessageListener;

  private class ServiceMessageListener implements SbEventListener<ServiceMessageEventArg>
  {
    @Override
    public void onEvent(ServiceMessageEventArg arg)
    {
      if ( arg.getState() == ServiceMessageEventArg.States.CONNECTED )
      {
        System.out.println("Connected.");
      }
      else if ( arg.getState() == ServiceMessageEventArg.States.DISCONNECTED )
      {
        System.out.println("Disconnected.");
      }
      else if ( arg.getState() == ServiceMessageEventArg.States.START_NETWORK_CALIBRATION )
      {
        System.out.println("Start network calibration, please wait...");
      }
      else if ( arg.getState() == ServiceMessageEventArg.States.FINISH_NETWORK_CALIBRATION )
      {
        System.out.println("Network calibration finished.");
      }
      else if ( arg.getState() == ServiceMessageEventArg.States.START_BANDWIDTH_CALIBRATION )
      {
        System.out.println("Start network bandwidth calibration, please wait...");
      }
      else if ( arg.getState() == ServiceMessageEventArg.States.FINISH_BANDWIDTH_CALIBRATION )
      {
        System.out.println("Network bandwidth calibration finished.");
      }
      else if ( arg.getState() == ServiceMessageEventArg.States.START_LATENCY_CALIBRATION )
      {
        System.out.println("Start network latency calibration, please wait...");
      }
      else if ( arg.getState() == ServiceMessageEventArg.States.FINISH_LATENCY_CALIBRATION )
      {
        System.out.println("Network latency calibration finished.");
      }
    }
  }

  public RemoteVizClientNode()
  {
    SoRemoteVizClient root = new SoRemoteVizClient();
    { // assemble scene graph
      root.ipAddress.setValue("127.0.0.1");
      root.port.setValue((short) 8080);
      // Add a listener to display connection informations
      root.onServiceMessage.addEventListener(serviceMessageListener);
      // Start the connection
      root.connect.setValue(true);
    }

    RenderAreaExaminer renderArea = new RenderAreaExaminer();
    renderArea.setSceneGraph(root);
    renderArea.viewAll(new SbViewportRegion(WIDTH, HEIGHT));

    setLayout(new BorderLayout());
    add(renderArea);
  }

  public static void main(String[] args)
  {
    RemoteVizClientNode demo = new RemoteVizClientNode();

    final Frame frame = new Frame("Open Inventor viewer using SoRemoteVizClient");
    frame.add(demo);
    frame.setSize(WIDTH, HEIGHT);
    frame.addWindowListener(new WindowAdapter()
    {
      @Override
      public void windowClosing(WindowEvent e)
      {
        System.exit(0);
      }
    });
    frame.setVisible(true);
  }

}
