package remoteviz.screendrawer;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

import com.openinventor.inventor.SbEventListener;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.drawers.SoLassoScreenDrawer;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.glcanvas.renderareas.RenderAreaExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.InteractionMode;
import com.openinventor.remoteviz.clients.nodes.SoRemoteVizClient;
import com.openinventor.remoteviz.clients.nodes.SoRemoteVizClient.ServiceMessageEventArg;

public class ScreenDrawerService extends JPanel
{

  private static final short HEIGHT = 480;
  private static final short WIDTH = 640;

  private class ServiceMessageListener implements SbEventListener<ServiceMessageEventArg>
  {
    @Override
    public void onEvent(ServiceMessageEventArg arg)
    {
      switch ( arg.getState() )
      {
      case CONNECTED :
        System.out.println("Connected.");
        break;
      case DISCONNECTED :
        System.out.println("Disconnected.");
        break;
      case START_NETWORK_CALIBRATION :
        System.out.println("Start network bandwidth calibration, please wait...");
        break;
      case FINISH_NETWORK_CALIBRATION :
        System.out.println("Network bandwidth calibration finished.");
        break;
      default:
        System.out.println("Unknown event.");
        break;
      }
    }
  }

  public ScreenDrawerService()
  {
    setLayout(new BorderLayout(0, 0));

    // Main node
    final SoSeparator root = new SoSeparator();

    // Create drawer
    SoLassoScreenDrawer drawer = new SoLassoScreenDrawer();
    root.addChild(drawer);

    SoRemoteVizClient remoteViz = new SoRemoteVizClient();
    {
      // Configure remoteViz node
      remoteViz.ipAddress.setValue("127.0.0.1");
      remoteViz.port.setValue((short) 8080);
      ServiceMessageListener serviceMessageListener = new ServiceMessageListener();
      // Add a listener to display connection informations
      remoteViz.onServiceMessage.addEventListener(serviceMessageListener);
      // Start the connection
      remoteViz.connect.setValue(true);
    }
    root.addChild(remoteViz);

    // RenderAreaExaminer
    RenderAreaExaminer renderArea = new RenderAreaExaminer();
    renderArea.setSceneGraph(root);
    renderArea.viewAll(new SbViewportRegion(WIDTH, HEIGHT));
    renderArea.setInteractionMode(InteractionMode.SELECTION);
    add(renderArea);

    // Radio buttons container
    final JPanel panel_1 = new JPanel();
    add(panel_1, BorderLayout.SOUTH);
    panel_1.setLayout(new BorderLayout(0, 0));

    // Radio buttons group
    final ButtonGroup buttonGroup = new ButtonGroup();

    // Add screen drawer radio button
    final JRadioButton screenDrawerButton = new JRadioButton("Screen Drawer");
    screenDrawerButton.setSelected(true);
    buttonGroup.add(screenDrawerButton);
    panel_1.add(screenDrawerButton, BorderLayout.NORTH);
    screenDrawerButton.addItemListener(new ItemListener()
    {
      @Override
      public void itemStateChanged(ItemEvent e)
      {
        if ( screenDrawerButton.isSelected() )
        {
          // Switch to screen drawer
          root.addChild(root.getChild(0));
          root.removeChild(0);
        }
      }
    });

    // Add render area radio button
    final JRadioButton renderAreaButton = new JRadioButton("RenderArea");
    buttonGroup.add(renderAreaButton);
    panel_1.add(renderAreaButton, BorderLayout.SOUTH);
    renderAreaButton.addItemListener(new ItemListener()
    {
      @Override
      public void itemStateChanged(ItemEvent e)
      {
        if ( renderAreaButton.isSelected() )
        {
          // Switch to lasso screen drawer
          root.addChild(root.getChild(0));
          root.removeChild(0);
        }
      }
    });
  }

  /**
   * @param args
   * @throws InterruptedException
   */
  public static void main(String[] args)
  {
    ScreenDrawerService demo = new ScreenDrawerService();
    final Frame frame = new Frame("Open Inventor viewer using SoRemoteVizClient");
    frame.add(demo);
    frame.setSize(WIDTH, HEIGHT);
    frame.setResizable(false);
    frame.addWindowListener(new WindowAdapter()
    {
      @Override
      public void windowClosing(WindowEvent e)
      {
        System.exit(0);
      }
    });
    frame.setVisible(true);
  }

}
