package util;

import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.viewercomponents.awt.IRenderArea;
import com.openinventor.inventor.viewercomponents.awt.IRenderAreaExaminer;
import com.openinventor.inventor.viewercomponents.awt.IRenderAreaInteractive;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

/**
 * Factory class for creating AWT render areas or viewers according to
 * {@code OIV_JAVA_VIEWER_TOOLKIT_TYPE} environment variable.<br>
 * Available values for this variable are:
 * <ul>
 * <li>{@code GLCanvas} to create render areas or viewers based on AWT GLCanvas
 * <li>{@code Newt} to create render areas or viewers based on AWT Newt canvas
 * </ul>
 * Default value is GLCanvas.
 *
 */
public class ViewerComponentsFactory
{
  private static final String VIEWER_PREF = "OIV_JAVA_VIEWER_TOOLKIT_TYPE";
  private static final String VIEWER_PREF_DEFAULT_VALUE = ViewerType.GLCANVAS.name();
  private static final int AREA_HEIGHT = 400;
  private static final int AREA_WIDTH = 400;

  private enum ViewerType
  {
    GLCANVAS, NEWT
  }

  public static IRenderArea createRenderArea()
  {
    final String viewerType = SoPreferences.getValue(VIEWER_PREF, VIEWER_PREF_DEFAULT_VALUE);
    IRenderArea area = null;

    if ( ViewerType.GLCANVAS.name().equalsIgnoreCase(viewerType) )
      area = new com.openinventor.inventor.viewercomponents.awt.glcanvas.renderareas.RenderArea();
    else if ( ViewerType.NEWT.name().equalsIgnoreCase(viewerType) )
      area = new com.openinventor.inventor.viewercomponents.awt.newt.renderareas.RenderArea();

    if ( area == null )
      throw new IllegalArgumentException(viewerType
          + " is not a valid value for \"OIV_JAVA_VIEWER_TOOLKIT_TYPE\" variable.\nValid values are GLCanvas or Newt.");

    // set render area default size
    area.getComponent().setSize(AREA_WIDTH, AREA_HEIGHT);
    return area;
  }

  public static IRenderAreaInteractive createRenderAreaInteractive()
  {
    final String viewerType = SoPreferences.getValue(VIEWER_PREF, VIEWER_PREF_DEFAULT_VALUE);
    IRenderAreaInteractive area = null;

    if ( ViewerType.GLCANVAS.name().equalsIgnoreCase(viewerType) )
      area = new com.openinventor.inventor.viewercomponents.awt.glcanvas.renderareas.RenderAreaInteractive();
    else if ( ViewerType.NEWT.name().equalsIgnoreCase(viewerType) )
      area = new com.openinventor.inventor.viewercomponents.awt.newt.renderareas.RenderAreaInteractive();

    if ( area == null )
      throw new IllegalArgumentException(viewerType
          + " is not a valid value for \"OIV_JAVA_VIEWER_TOOLKIT_TYPE\" variable.\nValid values are GLCanvas or Newt.");

    // set render area default size
    area.getComponent().setSize(AREA_WIDTH, AREA_HEIGHT);
    return area;
  }

  public static IRenderAreaExaminer createRenderAreaExaminer()
  {
    final String viewerType = SoPreferences.getValue(VIEWER_PREF, VIEWER_PREF_DEFAULT_VALUE);
    IRenderAreaExaminer area = null;

    if ( ViewerType.GLCANVAS.name().equalsIgnoreCase(viewerType) )
      area = new com.openinventor.inventor.viewercomponents.awt.glcanvas.renderareas.RenderAreaExaminer();
    else if ( ViewerType.NEWT.name().equalsIgnoreCase(viewerType) )
      area = new com.openinventor.inventor.viewercomponents.awt.newt.renderareas.RenderAreaExaminer();

    if ( area == null )
      throw new IllegalArgumentException(viewerType
          + " is not a valid value for \"OIV_JAVA_VIEWER_TOOLKIT_TYPE\" variable.\nValid values are GLCanvas or Newt.");

    // set render area default size
    area.getComponent().setSize(AREA_WIDTH, AREA_HEIGHT);
    return area;
  }

  public static IRenderAreaInteractive createRenderAreaOrbiter()
  {
    final String viewerType = SoPreferences.getValue(VIEWER_PREF, VIEWER_PREF_DEFAULT_VALUE);
    IRenderAreaInteractive area = null;

    if ( ViewerType.GLCANVAS.name().equalsIgnoreCase(viewerType) )
      area = new com.openinventor.inventor.viewercomponents.awt.glcanvas.renderareas.RenderAreaOrbiter();
    else if ( ViewerType.NEWT.name().equalsIgnoreCase(viewerType) )
      area = new com.openinventor.inventor.viewercomponents.awt.newt.renderareas.RenderAreaOrbiter();

    if ( area == null )
      throw new IllegalArgumentException(viewerType
          + " is not a valid value for \"OIV_JAVA_VIEWER_TOOLKIT_TYPE\" variable.\nValid values are GLCanvas or Newt.");

    // set render area default size
    area.getComponent().setSize(AREA_WIDTH, AREA_HEIGHT);
    return area;
  }

  public static IViewerExaminer createViewerExaminer()
  {
    final String viewerType = SoPreferences.getValue(VIEWER_PREF, VIEWER_PREF_DEFAULT_VALUE);
    IViewerExaminer viewer = null;

    if ( ViewerType.GLCANVAS.name().equalsIgnoreCase(viewerType) )
      viewer = new com.openinventor.inventor.viewercomponents.awt.glcanvas.viewers.ViewerExaminer();
    else if ( ViewerType.NEWT.name().equalsIgnoreCase(viewerType) )
      viewer = new com.openinventor.inventor.viewercomponents.awt.newt.viewers.ViewerExaminer();

    if ( viewer == null )
      throw new IllegalArgumentException(viewerType
          + " is not a valid value for \"OIV_JAVA_VIEWER_TOOLKIT_TYPE\" variable.\nValid values are GLCanvas or Newt.");

    viewer.getRenderArea().getComponent().setSize(AREA_WIDTH, AREA_HEIGHT);
    return viewer;
  }

}
