package util.editors;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

import com.openinventor.inventor.SbColor;

/**
 * This class simply draws a 3D looking patch of color.
 *
 */
class ColorPatch extends Canvas
{
  private SbColor color;

  ColorPatch()
  {
    super();
    color = new SbColor();
    color.setValue(0, 0, 0);
  }

  @Override
  public void paint(Graphics g)
  {
    Dimension d = getSize();
    Color backg = getBackground();
    Color darkerColor = backg.darker();
    Color brighterColor = backg.brighter();
    g.setColor(darkerColor);
    g.drawLine(0, 0, d.width - 2, 0);
    g.drawLine(0, 0, 0, d.height);
    g.setColor(brighterColor);
    g.drawLine(d.width - 1, 0, d.width - 1, d.height);
    g.drawLine(1, d.height - 1, d.width - 1, d.height - 1);

    redraw(g);
  }

  @Override
  public Dimension getPreferredSize()
  {
    return new Dimension(40, 40);
  }

  void setColor(SbColor rgb)
  {
    // save color
    color.setValue(rgb);

    // now show the color change
    redraw();
  }

  SbColor getColor()
  {
    return color;
  }

  void redraw()
  {
    Graphics g = getGraphics();
    if ( g != null )
      redraw(g);
  }

  private void redraw(Graphics g)
  {
    Dimension d = getSize();
    float[] colors = color.getValue();
    g.setColor(new Color(colors[0], colors[1], colors[2]));
    g.fillRect(4, 4, d.width - 8, d.height - 8);
  }
}
