package volumeviz.advanced.volRend;

import com.openinventor.inventor.nodes.*;
import com.openinventor.inventor.*;
import com.openinventor.ldm.nodes.*;
import com.openinventor.volumeviz.nodes.*;

public class InfoSep extends SoSeparator {
  private SoVolumeData m_volData;
  boolean m_showHistogram;
  boolean m_showColormap;
  boolean m_showText;

  SoTransferFunction m_transferFunction;
  SoTransferFunction m_sliceTransferFunction;

  ColorMapLegend m_cmLegend;
  SoText2 m_text;
  SoSwitch m_volColormapSwitch;
  SoSwitch m_volHistoSwitch;
  SoSwitch m_volTextSwitch;

  public InfoSep(SoVolumeData vol_data, SoTransferFunction transfer_func,
                 SoTransferFunction slice_transfer_func) {
    super();

    m_volData = vol_data;
    m_transferFunction = transfer_func;
    m_sliceTransferFunction = slice_transfer_func;

    build();
  }

  private void build() {
    SoOrthographicCamera p2Dcam = new SoOrthographicCamera();
    //SoPerspectiveCamera p2Dcam = new SoPerspectiveCamera();
    p2Dcam.nearDistance.setValue(0.5f);
    p2Dcam.farDistance.setValue(1.5f);

    SoLightModel pLightModel = new SoLightModel();
    pLightModel.model.setValue(SoLightModel.Models.BASE_COLOR);
    SoBaseColor pBaseColor = new SoBaseColor();
    pBaseColor.rgb.set1Value(0, new SbColor(1, 1, 1));

    SoFont pFont = new SoFont();
    m_text = new SoText2();
    SoTranslation pTran = new SoTranslation();
    pTran.translation.setValue(new SbVec3f( -.99f, -.95f, 0.49f));
    pFont.size.setValue(12);

    updateText();
    m_text.setName("VolumeViewerInfo");

    //colormap
    String prop = System.getProperty("VOLREND_showColormap", "true");
    m_showColormap = Boolean.valueOf(prop).booleanValue();
    m_volColormapSwitch = new SoSwitch();
    if (m_showColormap)
      m_volColormapSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
    else
      m_volColormapSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);

    m_cmLegend = new ColorMapLegend(m_transferFunction, m_sliceTransferFunction);
    m_volColormapSwitch.addChild(m_cmLegend);

    //histogram
    prop = System.getProperty("VOLREND_showHistogram", "true");
    m_showHistogram = Boolean.valueOf(prop).booleanValue();
    m_volHistoSwitch = new SoSwitch();
    if (m_showHistogram)
      m_volHistoSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
    else
      m_volHistoSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
    createHistoLegend(0);

    // Annotation text
    prop = System.getProperty("VOLREND_showText", "true");
    m_showText = Boolean.valueOf(prop).booleanValue();
    m_volTextSwitch = new SoSwitch();
    if (m_showText)
      m_volTextSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
    else
      m_volTextSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);

    SoPickStyle pUnpickable = new SoPickStyle();
    pUnpickable.style.setValue(SoPickStyle.Styles.UNPICKABLE);

    setName("_2DSep");
    {
      addChild(pUnpickable); // Shouldn't interfere with picking volume
      addChild(p2Dcam);
      addChild(pLightModel);
      addChild(pBaseColor);
      addChild(m_volColormapSwitch);
      addChild(m_volHistoSwitch);

      m_volTextSwitch.addChild(pTran);
      m_volTextSwitch.addChild(pFont);
      m_volTextSwitch.addChild(m_text);
      addChild(m_volTextSwitch);
    }
  }

  public void updateText() {
    SbVec3i32 vol_data_dim = m_volData.data.getSize();
    int numBytes = m_volData.getDataSize();
    float totbytes = (float) (vol_data_dim.getX() / 1024.f)
        * (float) vol_data_dim.getY() * (float) vol_data_dim.getZ()
        * (float) numBytes;

    long totalBytes = (long) totbytes;
    m_text.string.setValue("Volume: " + vol_data_dim.getX() + " x " +
                           vol_data_dim.getY() + " x " +
                           vol_data_dim.getZ() + " x " +
                           numBytes*8 + " bits  =  " + totalBytes / 1024 +
                           " MB");
  }

  public void createHistoLegend(int whichColormap) {
    if (m_volHistoSwitch == null)
      return;

    if (!m_showHistogram)
      return;

    // Legend (histogram)
    float legXmin = -.885f;
    float legXmax = -.78f;
    float legYmin = -.8f;
    float legYmax =  .8f;

    float[][] legLineVerts = {
        {legXmin,legYmin,0.0004f},
        {legXmax,legYmin,0.0004f},
        {legXmax,legYmax,0.0004f},
        {legXmin,legYmax,0.0004f}
    };
    int[] legLineIndex = {0, 1, 2, 3, 0};

    // LineSet to outline colormap
    SoVertexProperty pLegProp = new SoVertexProperty();
    pLegProp.vertex.setValues(0, legLineVerts);
    pLegProp.orderedRGBA.set1Value(0, 0xFFFFFFFF);
    SoIndexedLineSet pLegLine = new SoIndexedLineSet();
    pLegLine.vertexProperty.setValue(pLegProp);
    pLegLine.coordIndex.setValues(0, legLineIndex);

    float offset = 0.004f;
    float histXmin = legXmin + offset;
    float histXmax = legXmax - offset;
    float histYmin = legYmin + offset;
    float histYmax = legYmax - offset;
    float histLength = histYmax - histYmin;
    float histHeight = histXmax - histXmin;

    // Pull the legend out close to the near clip plane
    // (Note this depends on how the app setup the camera...)
    SoTranslation pTrans = new SoTranslation();
    pTrans.translation.setValue(new SbVec3f(0, 0, .499f));

    SoDrawStyle pStyle = new SoDrawStyle();
    pStyle.lineWidth.setValue(2);

    // Get histogram of data and find max value
    // (values outside the opaque range are ignored)
    long[] values = m_volData.getHistogram();
    if (values == null)
      return;

    int numBins = values.length;

    // Convert 16 bits histogram into 8 histogram
    if (numBins > 256) {
      for (int i = 0; i < 256; i++) {
        int sum = 0;
        for (int j = 0; j < 256; j++)
          sum += values[256*i+j];
        values[i] = sum;
      }
      numBins = 256;
    }

    int minColormap, maxColormap, minOpaqueMap, maxOpaqueMap;
    boolean invertTransparency;
    if (whichColormap == 0) {
      // volume
      minColormap  = VolRend.m_minColorMap;
      maxColormap  = VolRend.m_maxColorMap;
      minOpaqueMap = VolRend.m_minOpaqueMap;
      maxOpaqueMap = VolRend.m_maxOpaqueMap;
      invertTransparency = VolRend.m_invertTransparency;
    } else {
      // slices
      minColormap  = VolRend.m_minSliceColorMap;
      maxColormap  = VolRend.m_maxSliceColorMap;
      minOpaqueMap = VolRend.m_minSliceOpaqueMap;
      maxOpaqueMap = VolRend.m_maxSliceOpaqueMap;
      invertTransparency = VolRend.m_invertSliceTransparency;
    }

    // Find max value
    long maxVal = 0;
    int maxBin = -1;
    for (int i = 0; i < numBins; i++) {
      if (!(minColormap <= i && i <= maxColormap))
        continue;
      if ((minOpaqueMap <= i && i <= maxOpaqueMap) == invertTransparency)
        continue;
      if (values[i] > maxVal) {
        maxVal = values[i];
        maxBin = i;
      }
    }

    // Find max value again, ignoring the largest value (probably a spike)
    maxVal = 0;
    for (int i = 0; i < numBins; i++) {
      if (!(minColormap <= i && i <= maxColormap))
        continue;
      if ((minOpaqueMap <= i && i <= maxOpaqueMap) == invertTransparency)
        continue;
      if (i == maxBin)
        continue;
      if (values[i] > maxVal)
        maxVal = values[i];
    }

    SoLineSet pBinLines = new SoLineSet();
    // If maxVal is zero, then we don't actually have any data
    // (possibly could not open input file), so don't draw a
    // bunch of garbage in the histogram.       --mmh Dec-2000
    if (maxVal > 0) {
      SoVertexProperty pBinProp = new SoVertexProperty();
      pBinProp.vertex.setNum(2 * numBins);
      pBinProp.orderedRGBA.set1Value(0, 0xFF6F2FFF);
      pBinLines.vertexProperty.setValue(pBinProp);
      pBinLines.numVertices.setNum(numBins-1);
      int vertIndex  = 0;
      int indexIndex = 0;
      for (int i = 0; i < numBins; i++) {
        float y = histYmin + i * (histLength/numBins);
        pBinProp.vertex.set1Value( vertIndex, histXmax, y, 0 );
        vertIndex++;
        // Note values below opaque range are ignored.
        // Do NOT modify the contents of the values array!
        // Any changes are permanent (until next volume loaded)
        float val;
        if ((minOpaqueMap <= i && i <= maxOpaqueMap) == invertTransparency)
          val = 0;
        else
          val = (float)((values[i] > maxVal) ? maxVal : values[i]);

        float x = histXmax - ((val/(float)maxVal)*histHeight);
        pBinProp.vertex.set1Value( vertIndex, x, y, 0 );
        pBinLines.numVertices.set1Value( indexIndex++, 2 );
        vertIndex++;
      }
    }

    // Build the legend scene graph
    SoSeparator pLegSep = new SoSeparator();
    {
      pLegSep.addChild(pTrans);
      pLegSep.addChild(pLegLine);
      pLegSep.addChild(pStyle);
      pLegSep.addChild(pBinLines);
    }

    if (m_volHistoSwitch.getNumChildren() != 0)
      m_volHistoSwitch.replaceChild(0, pLegSep);
    else
      m_volHistoSwitch.addChild(pLegSep);
  }
}
