package volumeviz.advanced.volRend;

import javax.swing.*;
import java.awt.*;
import javax.swing.border.*;
import java.awt.event.*;

public class InterpolationPanel extends JPanel {
  private JCheckBox m_linearBox;
  private JCheckBox m_nearestBox;

  public InterpolationPanel() {
    try {
      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    m_linearBox = new JCheckBox("Linear", true);
    m_nearestBox = new JCheckBox("Nearest", false);
    ButtonGroup group = new ButtonGroup();
    group.add(m_linearBox);
    group.add(m_nearestBox);
    JPanel panel = new JPanel();
    panel.add(m_linearBox);
    panel.add(m_nearestBox);
    setLayout(new BorderLayout());
    setBorder(new TitledBorder(new EtchedBorder(), "Interpolation"));
    add(panel, BorderLayout.WEST);
  }

  public void setLinearOn(boolean on) {
    m_linearBox.setSelected(on);
    m_nearestBox.setSelected(!on);
  }

  public void addLinearInterpolationListener(ItemListener listener) {
    m_linearBox.addItemListener(listener);
  }
}
