package volumeviz.advanced.volRend;

import com.openinventor.volumeviz.nodes.*;
import com.openinventor.ldm.SoLDMGlobalResourceParameters;
import com.openinventor.ldm.nodes.*;

import javax.swing.*;

import java.awt.*;
import java.awt.event.*;

import com.openinventor.inventor.*;

public class LDMOptionsPanel extends VolRendPanel {
  private final String[] m_tileSizeItems = {
      "32", "64", "128", "256", "512", "1024"
  };
  private final String[] m_loadingPolicyItems = {
      "No Interaction",
      "Always",
      "Never"
  };
  private final String[] m_resThresholdItems = {
      "Max", "1/2", "1/4", "1/8", "1/16", "1/32", "1/64"
  };

  private SoVolumeData m_volData;
  private JComboBox<String> m_minResThreshold;

  public LDMOptionsPanel(SoVolumeData vol_data) {
    super("OPTIONS");
    m_volData = vol_data;

    try {
      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    /********* Box panel *********/
    JCheckBox culling = new JCheckBox("View Culling");
    culling.addItemListener(new CullingListener());
    culling.setSelected(true);
    JCheckBox viewpoint_refinement = new JCheckBox("View Point Refinement");
    viewpoint_refinement.setSelected(true);
    viewpoint_refinement.addItemListener(new ViewPointRefListener());
    JCheckBox best_equal_resolution = new JCheckBox("Best Equal Resolution");
    best_equal_resolution.addItemListener(new BestEqualResListener());
    JCheckBox move_low_res = new JCheckBox("Move low Resolution");
    move_low_res.addItemListener(new MoveLowResListener());
    JCheckBox ignore_fully_transparency = new JCheckBox("Ignore Fully Transparent Tiles");
    ignore_fully_transparency.setSelected(true);
    ignore_fully_transparency.addItemListener(new FullyTranspListener());

    GridLayout gr_layout = new GridLayout(3, 2);
    gr_layout.setVgap(10);
    JPanel box_panel = new JPanel(gr_layout);
    box_panel.add(culling);
    box_panel.add(viewpoint_refinement);
    box_panel.add(best_equal_resolution);
    box_panel.add(move_low_res);
    box_panel.add(ignore_fully_transparency);

    /********* ComboBox panel *********/
    Dimension label_dim = new Dimension(150, 20);
    Dimension comboBox_dim = new Dimension(117, 20);
    // Tile size
    JLabel tile_size_label = new JLabel("Tile Size");
    tile_size_label.setPreferredSize(label_dim);
    JComboBox<String> tile_size = new JComboBox<>(m_tileSizeItems);
    tile_size.setPreferredSize(comboBox_dim);
    tile_size.setSelectedIndex(1);
    tile_size.addActionListener(new TileSizeListener());
    JPanel tile_size_panel = new JPanel();
    tile_size_panel.add(tile_size_label);
    tile_size_panel.add(tile_size);

    // Loading policy
    JLabel loading_policy_label = new JLabel("Loading Policy");
    loading_policy_label.setPreferredSize(label_dim);
    JComboBox<String> loading_policy = new JComboBox<>(m_loadingPolicyItems);
    loading_policy.setPreferredSize(comboBox_dim);
    loading_policy.addActionListener(new LoadingPolicyListener());
    JPanel loading_policy_panel = new JPanel();
    loading_policy_panel.add(loading_policy_label);
    loading_policy_panel.add(loading_policy);

    // Min resolution threshold
    JLabel min_res_threshold_label = new JLabel("Min Resolution Threshold");
    min_res_threshold_label.setPreferredSize(label_dim);
    m_minResThreshold = new JComboBox<>(m_resThresholdItems);
    m_minResThreshold.setPreferredSize(comboBox_dim);
    m_minResThreshold.addActionListener(new MinResThresholdListener());
    m_minResThreshold.setSelectedIndex(1);
    JPanel m_minResThreshold_panel = new JPanel();
    m_minResThreshold_panel.add(min_res_threshold_label);
    m_minResThreshold_panel.add(m_minResThreshold);

    // Max resolution threshold
    JLabel max_res_threshold_label = new JLabel("Max Resolution Threshold");
    max_res_threshold_label.setPreferredSize(label_dim);
    JComboBox<String> max_res_threshold = new JComboBox<>(m_resThresholdItems);
    max_res_threshold.setPreferredSize(comboBox_dim);
    max_res_threshold.addActionListener(new MaxResThresholdListener());
    JPanel max_res_threshold_panel = new JPanel();
    max_res_threshold_panel.add(max_res_threshold_label);
    max_res_threshold_panel.add(max_res_threshold);

    SpringLayout sp_layout = new SpringLayout();
    JPanel center_panel = new JPanel(sp_layout);
    center_panel.add(tile_size_panel);
    center_panel.add(loading_policy_panel);
    center_panel.add(m_minResThreshold_panel);
    center_panel.add(max_res_threshold_panel);

    sp_layout.putConstraint(SpringLayout.NORTH, tile_size_panel, 20,
                            SpringLayout.NORTH, center_panel);
    sp_layout.putConstraint(SpringLayout.NORTH, loading_policy_panel, 15,
                            SpringLayout.SOUTH, tile_size_panel);
    sp_layout.putConstraint(SpringLayout.NORTH, m_minResThreshold_panel, 15,
                            SpringLayout.SOUTH, loading_policy_panel);
    sp_layout.putConstraint(SpringLayout.NORTH, max_res_threshold_panel, 15,
                            SpringLayout.SOUTH, m_minResThreshold_panel);

    setLayout(new BorderLayout());
    add(box_panel, BorderLayout.NORTH);
    add(center_panel, BorderLayout.CENTER);
  }

  public void reset() {
    SbVec3i32 dim = m_volData.data.getSize();
    int tile_size = 64;

    // compute level max
    int max_dim = dim.getX();
    if (dim.getY() > max_dim)
      max_dim = dim.getY();
    if (dim.getZ() > max_dim)
      max_dim = dim.getZ();
    int level_max;
    for (level_max = 0; (1<<level_max)*tile_size < max_dim; level_max++)
      m_minResThreshold.setSelectedIndex(level_max-1);
  }

  class CullingListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
    	SoLDMGlobalResourceParameters.setViewCulling(e.getStateChange() == ItemEvent.SELECTED);
      m_volData.touch();
    }
  }

  class ViewPointRefListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
    	SoLDMGlobalResourceParameters.setViewpointRefinement(e.getStateChange() == ItemEvent.SELECTED);
      m_volData.touch();
    }
  }

  class BestEqualResListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
        SoLDMResourceParameters resParams = m_volData.ldmResourceParameters.getValue();
        resParams.resolution.setValue(-1);
        resParams.fixedResolution.setValue(e.getStateChange() == ItemEvent.SELECTED);
      m_volData.touch();
    }
  }

  class MoveLowResListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
    	SoLDMGlobalResourceParameters.setMoveLowResolution(e.getStateChange() == ItemEvent.SELECTED);
      m_volData.touch();
    }
  }

  class FullyTranspListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
    	SoLDMGlobalResourceParameters.setIgnoreFullyTransparentTiles(e.getStateChange() ==
                                                 ItemEvent.SELECTED);
      m_volData.touch();
    }
  }

  class TileSizeListener implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      if(m_volData.fileName.getValue().endsWith(".ldm"))
        System.err.println("Inventor warning in SoVolumeData.setTileSize():\n"+
                           "The data is stored in a LDM file, cannot change size!");
      else {
        JComboBox<?> comboBox = (JComboBox<?>) e.getSource();
        int selected_size = Integer.parseInt( (String) comboBox.getSelectedItem());
        int tile_size = 1 << (selected_size + 5);
        m_volData.ldmResourceParameters.getValue().tileDimension.setValue(tile_size, tile_size, tile_size);
      }
    }
  }

  class LoadingPolicyListener implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      int selected_index = ((JComboBox<?>)e.getSource()).getSelectedIndex();
      SoLDMResourceParameters resParams = m_volData.ldmResourceParameters.getValue(); 
      switch (selected_index) {
        case 0:
          resParams.loadPolicy.setValue(SoLDMResourceParameters.LoadPolicies.NO_USER_INTERACTION);
          break;
        case 1 :
        	resParams.loadPolicy.setValue(SoLDMResourceParameters.LoadPolicies.ALWAYS);
          break;
        case 2 :
        	resParams.loadPolicy.setValue(SoLDMResourceParameters.LoadPolicies.NEVER);
          break;
        default:
          break;
      }
    }
  }

  class MinResThresholdListener implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      int selected_index = ((JComboBox<?>)e.getSource()).getSelectedIndex();
      m_volData.ldmResourceParameters.getValue().minResolutionThreshold.setValue(selected_index);
    }
  }

  class MaxResThresholdListener implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      int selected_index = ((JComboBox<?>)e.getSource()).getSelectedIndex();
      m_volData.ldmResourceParameters.getValue().maxResolutionThreshold.setValue(selected_index);
    }
  }

}
