package volumeviz.advanced.volRend;

import java.awt.event.*;
import javax.swing.*;
import com.openinventor.inventor.nodes.*;
import com.openinventor.volumeviz.nodes.*;
import java.awt.*;

public class ObliqueSlicePanel extends VolRendPanel {
  private String[] m_alphaTypeItems = {
      "Binary",
      "As Is",
      "Opaque"
  };

  private SliceGroup m_sliceGroup;
  private JCheckBox m_draggerBox;

  public ObliqueSlicePanel(SliceGroup slice_group) {
    super("OBLIQUE SLICE");
    m_sliceGroup = slice_group;

    try {
      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    // Box panel
    JCheckBox visible = new JCheckBox("Visible");
    visible.addItemListener(new VisibleListener());

    JCheckBox clipping = new JCheckBox("Clipping");
    clipping.addItemListener(new ClippingListener());

    m_draggerBox = new JCheckBox("Dragger", true);
    m_draggerBox.addItemListener(new DraggerVisibilityListener());

    GridLayout grid_layout = new GridLayout(4, 1);
    grid_layout.setVgap(10);
    JPanel box_panel = new JPanel(grid_layout);
    box_panel.add(visible);
    box_panel.add(clipping);
    box_panel.add(m_draggerBox);

    // Options panel
    InterpolationPanel interpolation = new InterpolationPanel();
    interpolation.addLinearInterpolationListener(new InterpolationListener());

    JLabel alpha_type_label = new JLabel("Alpha Type");
    JComboBox<String> alpha_type = new JComboBox<>(m_alphaTypeItems);
    alpha_type.addActionListener(new AlphaTypeListener());

    SpringLayout sp_layout = new SpringLayout();
    JPanel alpha_type_panel = new JPanel(sp_layout);
    alpha_type_panel.add(alpha_type_label);
    alpha_type_panel.add(alpha_type);

    sp_layout.putConstraint(SpringLayout.NORTH, alpha_type_label, 33,
                            SpringLayout.NORTH, alpha_type_panel);
    sp_layout.putConstraint(SpringLayout.WEST, alpha_type_label, 5,
                            SpringLayout.WEST, alpha_type_panel);
    sp_layout.putConstraint(SpringLayout.NORTH, alpha_type, 30,
                            SpringLayout.NORTH, alpha_type_panel);
    sp_layout.putConstraint(SpringLayout.WEST, alpha_type, 25,
                            SpringLayout.EAST, alpha_type_label);

    JPanel panel = new JPanel(new BorderLayout());
    panel.add(interpolation, BorderLayout.NORTH);
    panel.add(alpha_type_panel, BorderLayout.CENTER);

    setLayout(new BorderLayout());
    add(box_panel, BorderLayout.NORTH);
    add(panel, BorderLayout.CENTER);
  }

  public void reset() {
    m_draggerBox.setSelected(false);
  }

  class VisibleListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      if (e.getStateChange() == ItemEvent.SELECTED)
        m_sliceGroup.m_volRenderObliSliceSwitch.whichChild.setValue
            (SoSwitch.WhichChild.SO_SWITCH_ALL.getValue());
      else
        m_sliceGroup.m_volRenderObliSliceSwitch.whichChild.setValue
            (SoSwitch.WhichChild.SO_SWITCH_NONE.getValue());
    }
  }

  class InterpolationListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      if (e.getStateChange() == ItemEvent.SELECTED)
        m_sliceGroup.m_obliSlice.interpolation.setValue(SoVolumeShape.Interpolations.LINEAR);
      else
        m_sliceGroup.m_obliSlice.interpolation.setValue(SoVolumeShape.Interpolations.NEAREST);
    }
  }

  class ClippingListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      m_sliceGroup.m_obliClipPlane.on.setValue
          (e.getStateChange() == ItemEvent.SELECTED);
    }
  }

  class DraggerVisibilityListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      if (e.getStateChange() == ItemEvent.SELECTED)
        m_sliceGroup.m_draggerObliSwitch.whichChild.setValue
            (SoSwitch.WhichChild.SO_SWITCH_ALL.getValue());
      else
        m_sliceGroup.m_draggerObliSwitch.whichChild.setValue
            (SoSwitch.WhichChild.SO_SWITCH_NONE.getValue());
    }
  }

  class AlphaTypeListener implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      int selected_item = ((JComboBox<?>)e.getSource()).getSelectedIndex();
      switch (selected_item) {
        case 0:
          m_sliceGroup.m_obliSlice.alphaUse.setValue(SoOrthoSlice.AlphaUses.ALPHA_BINARY);
          break;
        case 1:
          m_sliceGroup.m_obliSlice.alphaUse.setValue(SoOrthoSlice.AlphaUses.ALPHA_AS_IS);
          break;
        case 2:
          m_sliceGroup.m_obliSlice.alphaUse.setValue(SoOrthoSlice.AlphaUses.ALPHA_OPAQUE);
          break;
      }
    }
  }
}
