package volumeviz.advanced.volRend;

import javax.swing.*;
import java.awt.event.*;
import javax.swing.border.*;
import java.awt.*;

public class OnOffButtonPanel extends JPanel {

  private JCheckBox m_onBox;
  private JCheckBox m_offBox;
  private JPanel m_panel;

  public OnOffButtonPanel(String title, boolean on) {
    m_onBox = new JCheckBox("On", on);
    m_offBox = new JCheckBox("Off", !on);
    ButtonGroup group = new ButtonGroup();
    group.add(m_onBox);
    group.add(m_offBox);

    m_panel = new JPanel();
    m_panel.add(m_onBox);
    m_panel.add(m_offBox);

    setLayout(new BorderLayout());
    add(m_panel, BorderLayout.WEST);
    setBorder(new TitledBorder(new EtchedBorder(), title));
  }

  public void addPanel(JPanel panel) {
    m_panel.add(panel);
  }

  public void setOn(boolean on) {
    m_onBox.setSelected(on);
    m_offBox.setSelected(!on);
  }

  public void addOnItemListener(ItemListener listener) {
    m_onBox.addItemListener(listener);
  }
}
