package volumeviz.advanced.volRend;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbVec3i32;
import com.openinventor.inventor.nodes.SoSwitch;
import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;
import com.openinventor.volumeviz.nodes.SoOrthoSlice;

public class OrthoSlicePanel extends VolRendPanel {
  private String[] m_draggerOrientItems = {"X", "Y", "Z"};
  private String[] m_alphaTypeItems = {
      "Binary",
      "As Is",
      "Opaque"
  };

  private int m_number;
  private boolean m_draggerOn = false;
  private VolRend m_volRend;

  private JCheckBox m_visible;
  private JCheckBox m_clipping;
  private JCheckBox m_dragger;
  private JCheckBox m_front;
  private JCheckBox m_back;
  private JComboBox<String> m_orientBox;
  private InterpolationPanel m_interpolation;
  private JComboBox<String> m_alphaType;
  private SliderPanel m_sliceNbSlider;

  public OrthoSlicePanel(int nb, VolRend vol_rend) {
    super("ORTHO SLICE " + nb);

    m_number = nb;
    m_volRend = vol_rend;

    try {
      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    m_visible = new JCheckBox("Visible");
    m_visible.addItemListener(new VisibleListener());
    JPanel visible_panel = new JPanel(new GridLayout(2, 1));
    visible_panel.add(m_visible);

    // Clipping panel
    m_clipping = new JCheckBox("On");
    m_clipping.setPreferredSize(new Dimension(80, 20));
    m_clipping.addItemListener(new ClippingListener());
    JPanel clipping_side = new JPanel();
    m_front = new JCheckBox("Front");
    m_front.addItemListener(new ClippingSideListener());
    m_back = new JCheckBox("Back", true);
    ButtonGroup bg = new ButtonGroup();
    bg.add(m_front);
    bg.add(m_back);
    clipping_side.add(new JLabel("Side"));
    clipping_side.add(m_front);
    clipping_side.add(m_back);

    JPanel clipping = new JPanel();
    clipping.add(m_clipping);
    clipping.add(clipping_side);
    JPanel clipping_panel = new JPanel(new BorderLayout());
    clipping_panel.setBorder(new TitledBorder(new EtchedBorder(), "Clipping"));
    clipping_panel.add(clipping, BorderLayout.WEST);

    // Dragger panel
    m_dragger = new JCheckBox("Visible");
    m_dragger.setPreferredSize(new Dimension(80, 20));
    m_dragger.addItemListener(new DraggerVisibilityListener());
    JPanel dragger_orientation = new JPanel();
    m_orientBox = new JComboBox<>(m_draggerOrientItems);
    m_orientBox.setPreferredSize(new Dimension(50, 20));
    m_orientBox.setSelectedIndex(2);
    m_orientBox.addActionListener(new DraggerOrientListener());
    dragger_orientation.add(new JLabel("Orientation"));
    dragger_orientation.add(m_orientBox);

    JPanel dragger = new JPanel();
    dragger.add(m_dragger);
    dragger.add(dragger_orientation);
    JPanel dragger_panel = new JPanel(new BorderLayout());
    dragger_panel.setBorder(new TitledBorder(new EtchedBorder(), "Dragger"));
    dragger_panel.add(dragger, BorderLayout.WEST);


    // Interpolation panel
    m_interpolation = new InterpolationPanel();
    m_interpolation.addLinearInterpolationListener(new InterpolationListener());

    JPanel panel1 = new JPanel(new GridLayout(3, 1));
    panel1.add(clipping_panel);
    panel1.add(dragger_panel);
    panel1.add(m_interpolation);

    JLabel alpha_type_label = new JLabel("Alpha Type");
    m_alphaType = new JComboBox<>(m_alphaTypeItems);
    m_alphaType.addActionListener(new AlphaTypeListener());
    m_sliceNbSlider =
        new SliderPanel(0, m_volRend.m_volData.data.getSize().getZ()-1,
                        m_volRend.m_sliceGroup.m_orthoTab[m_number-1].sliceNumber.getValue());
    m_sliceNbSlider.addInfoText("Slice Number");
    m_sliceNbSlider.setInfoTextSize(new Dimension(88, 25));
    m_sliceNbSlider.addSliderPanelListener(new SliceNbListener());

    SpringLayout sp_layout = new SpringLayout();
    JPanel options_panel = new JPanel(sp_layout);
    options_panel.add(alpha_type_label);
    options_panel.add(m_alphaType);
    options_panel.add(m_sliceNbSlider);

    sp_layout.putConstraint(SpringLayout.NORTH, alpha_type_label, 23,
                            SpringLayout.NORTH, options_panel);
    sp_layout.putConstraint(SpringLayout.WEST, alpha_type_label, 5,
                            SpringLayout.WEST, options_panel);
    sp_layout.putConstraint(SpringLayout.NORTH, m_alphaType, 20,
                            SpringLayout.NORTH, options_panel);
    sp_layout.putConstraint(SpringLayout.WEST, m_alphaType, 35,
                            SpringLayout.EAST, alpha_type_label);
    sp_layout.putConstraint(SpringLayout.NORTH, m_sliceNbSlider, 10,
                            SpringLayout.SOUTH, m_alphaType);

    JPanel panel2 = new JPanel(new BorderLayout());
    panel2.add(panel1, BorderLayout.NORTH);
    panel2.add(options_panel, BorderLayout.CENTER);

    setLayout(new BorderLayout());
    add(visible_panel, BorderLayout.NORTH);
    add(panel2, BorderLayout.CENTER);
    addAncestorListener(new PanelAncestorListener());
  }

  public void resetPanel(int slice_nb) {
    if (m_volRend.m_sliceGroup.m_volRenderOrthSliceSwitch.whichChild.getValue()
        == SoSwitch.SO_SWITCH_NONE)
      m_visible.setSelected(false);
    else
      m_visible.setSelected(true);

    m_interpolation.setLinearOn(true);
    m_clipping.setSelected(false);
    m_front.setSelected(false);
    m_back.setSelected(true);
    m_dragger.setSelected(false);
    m_orientBox.setSelectedIndex(2);
    m_sliceNbSlider.setSliderValue(slice_nb);
    m_alphaType.setSelectedIndex(0);

    SoOrthoSlice.AxisType axe= m_volRend.m_sliceGroup.m_orthoTab[m_number-1].axis.getValue(SoOrthoSlice.AxisType.class);
    SbVec3i32 vol_dim = m_volRend.m_volData.data.getSize(); 
    switch (axe) {
      case X:
        m_sliceNbSlider.setSliderMax(vol_dim.getX() - 1);
        break;
      case Y:
        m_sliceNbSlider.setSliderMax(vol_dim.getY() - 1);
        break;
      case Z:
        m_sliceNbSlider.setSliderMax(vol_dim.getZ() - 1);
        break;
    }
  }

  public void setSliceVisible(boolean visible) {
    m_visible.setSelected(visible);
  }

  class VisibleListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      if (e.getStateChange() == ItemEvent.SELECTED) {
        if (m_volRend.m_sliceGroup.m_volRenderOrthSliceSwitch.whichChild.getValue()
            == SoSwitch.SO_SWITCH_NONE)
          m_volRend.m_sliceGroup.m_volRenderOrthSliceSwitch.whichChild.
              setValue(SoSwitch.SO_SWITCH_ALL);

        m_volRend.m_sliceGroup.m_switchOrthoTab[m_number - 1].
            whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
      } else
        m_volRend.m_sliceGroup.m_switchOrthoTab[m_number-1].
            whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
    }
  }

  class InterpolationListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      if (e.getStateChange() == ItemEvent.SELECTED)
        m_volRend.m_sliceGroup.m_orthoTab[m_number-1].interpolation.
            setValue(SoOrthoSlice.Interpolations.LINEAR);
      else
        m_volRend.m_sliceGroup.m_orthoTab[m_number-1].interpolation.
            setValue(SoOrthoSlice.Interpolations.NEAREST);
    }
  }

  class ClippingListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
        m_volRend.m_sliceGroup.m_orthoTab[m_number-1].
            clipping.setValue(e.getStateChange() == ItemEvent.SELECTED);
    }
  }

  class ClippingSideListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      if (e.getStateChange() == ItemEvent.SELECTED)
        m_volRend.m_sliceGroup.m_orthoTab[m_number-1].clippingSide.
            setValue(SoOrthoSlice.ClippingSides.FRONT);
      else
        m_volRend.m_sliceGroup.m_orthoTab[m_number-1].clippingSide.
            setValue(SoOrthoSlice.ClippingSides.BACK);
    }
  }

  class DraggerVisibilityListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      if (e.getStateChange() == ItemEvent.SELECTED) {
        m_volRend.m_sliceGroup.m_draggerVolRenderSwitch.whichChild.
            setValue(SoSwitch.SO_SWITCH_ALL);
        m_draggerOn = true;
      } else {
        m_volRend.m_sliceGroup.m_draggerVolRenderSwitch.whichChild.
            setValue(SoSwitch.SO_SWITCH_NONE);
        m_draggerOn = false;
      }
    }
  }

  class DraggerOrientListener implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      int selected_item = ((JComboBox<?>)e.getSource()).getSelectedIndex();
      int sliceMax = 0;
      int sliceNumber = m_volRend.m_sliceGroup.m_orthoTab[m_number-1].
          sliceNumber.getValue();
      SbVec3i32 vol_dim = m_volRend.m_volData.data.getSize();

      switch (selected_item) {
        case 0:
          m_volRend.m_sliceGroup.m_orthoTab[m_number-1].axis.setValue(SoOrthoSlice.AxisType.X);
          sliceMax = vol_dim.getX()-1;
          break;
        case 1:
          m_volRend.m_sliceGroup.m_orthoTab[m_number-1].axis.setValue(SoOrthoSlice.AxisType.Y);
          sliceMax = vol_dim.getY()-1;
          break;
        case 2:
          m_volRend.m_sliceGroup.m_orthoTab[m_number-1].axis.setValue(SoOrthoSlice.AxisType.Z);
          sliceMax = m_volRend.m_volData.data.getSize().getZ()-1;
          break;
      }

      m_volRend.m_sliceGroup.resetDraggerPos(sliceNumber);
      // Make slice number max value appropriate for this axis
      // and set the new slice number
      m_sliceNbSlider.setSliderValue(sliceNumber);
      m_sliceNbSlider.setSliderMax(sliceMax);
    }
  }

  class AlphaTypeListener implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      int selected_item = ((JComboBox<?>)e.getSource()).getSelectedIndex();
      switch (selected_item) {
        case 0:
          m_volRend.m_sliceGroup.m_orthoTab[m_number-1].alphaUse.setValue(SoOrthoSlice.AlphaUses.ALPHA_BINARY);
          break;
        case 1:
          m_volRend.m_sliceGroup.m_orthoTab[m_number-1].alphaUse.setValue(SoOrthoSlice.AlphaUses.ALPHA_AS_IS);
          break;
        case 2:
          m_volRend.m_sliceGroup.m_orthoTab[m_number-1].alphaUse.setValue(SoOrthoSlice.AlphaUses.ALPHA_OPAQUE);
          break;
      }
    }
  }

  class SliceNbListener extends SliderPanel.Listener {
    public void stateChanged(float value) {
      m_volRend.m_sliceGroup.m_orthoTab[m_number-1].sliceNumber.setValue((int)value);
      // Move dragger
      SbVec3f dragger_pos = m_volRend.m_sliceGroup.m_draggerSlicePos;
      SoOrthoSlice.AxisType axe = m_volRend.m_sliceGroup.m_orthoTab[m_number-1].axis.getValue(SoOrthoSlice.AxisType.class);
      SbVec3i32 vol_dim = m_volRend.m_volData.data.getSize();
      SbVec3f[] vol_bounds = m_volRend.m_volData.extent.getValue().getMinMax();
      switch (axe) {
        case X:
          // m_width = number of slices
          // m_min/maxWidth = min/max X values of volume geometry
          float xFrac = value / (vol_dim.getX()-1);
          dragger_pos.setX(vol_bounds[0].getX() + xFrac*(vol_bounds[1].getX()-vol_bounds[0].getX()));
          break;
        case Y:
          float yFrac = value / (vol_dim.getY()-1);
          dragger_pos.setY(vol_bounds[0].getY() + yFrac*(vol_bounds[1].getY()-vol_bounds[0].getY()));
          break;
        case Z:
          float zFrac = value / (vol_dim.getZ()-1);
          dragger_pos.setZ(vol_bounds[0].getZ() + zFrac*(vol_bounds[1].getZ()-vol_bounds[0].getZ()));
          break;
      }
      m_volRend.m_sliceGroup.m_draggerSlicePos = dragger_pos;
      m_volRend.m_sliceGroup.m_draggerVolRender.enableValueChangedCallbacks(false);
      m_volRend.m_sliceGroup.m_draggerVolRender.translation.setValue(dragger_pos);
      m_volRend.m_sliceGroup.m_draggerVolRender.enableValueChangedCallbacks(true);
    }
  }

  class PanelAncestorListener implements AncestorListener {
    public void ancestorAdded(AncestorEvent e) {
      if (e.getAncestor() instanceof OrthoSlicePanel){
        m_volRend.m_sliceGroup.m_currentSlice = m_number-1;
        m_volRend.m_sliceGroup.resetDraggerPos
            (m_volRend.m_sliceGroup.m_orthoTab[m_number-1].sliceNumber.getValue());

        if (m_draggerOn)
          m_volRend.m_sliceGroup.m_draggerVolRenderSwitch.whichChild.
              setValue(SoSwitch.SO_SWITCH_ALL);
        else
          m_volRend.m_sliceGroup.m_draggerVolRenderSwitch.whichChild.
              setValue(SoSwitch.SO_SWITCH_NONE);
      }
    }

    public void ancestorRemoved(AncestorEvent e) {}
    public void ancestorMoved(AncestorEvent e) {}
  }
}
