package volumeviz.advanced.volRend;

import com.openinventor.inventor.nodes.*;
import com.openinventor.inventor.*;
import com.openinventor.volumeviz.nodes.*;

public class VolAxesSwitch extends SoSwitch {

  private SoVolumeData m_volData;
  private SoSeparator m_XRoot;
  private SoSeparator m_YRoot;
  private SoSeparator m_ZRoot;
  boolean m_showAxes;

  public VolAxesSwitch(SoVolumeData vol_data) {
    super();
    m_volData = vol_data;
    m_XRoot = null;
    m_YRoot = null;
    m_ZRoot = null;

    String prop = System.getProperty("VOLREND_showAxes", "false");
    m_showAxes = Boolean.valueOf(prop).booleanValue();
    if (m_showAxes)
      whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
  }

  public void update() {
    SbBox3f vol_size = m_volData.extent.getValue();
    float[] size = vol_size.getSize().getValue();
    SbVec3f center = vol_size.getCenter();

    // Position axes at center of volume
    SoTranslation pPos = new SoTranslation();
    pPos.translation.setValue(center);

    float coneHeight = (size[0]/20) + (size[1]/20) + (size[2]/20);
    coneHeight /= 3;

    if (m_XRoot == null) {
      m_XRoot = new SoSeparator();
      m_XRoot.setName("MISC_XGEOM");
      addChild(m_XRoot);
    } else
      m_XRoot.removeAllChildren();

    {
      SoMaterial pMat = new SoMaterial();
      pMat.diffuseColor.setValue(new SbColor(1, 0, 0));
      SoRotation pRot = new SoRotation();
      pRot.rotation.setValue(new SbRotation(new SbVec3f(0, 0, -1), VolRend.PIO2));
      SoCylinder pCyl = new SoCylinder();
      pCyl.height.setValue(size[0]);
      pCyl.radius.setValue(size[1] / 100);
      SoTranslation pTran = new SoTranslation();
      pTran.translation.setValue(new SbVec3f(0, (size[0]/2 + coneHeight/2), 0));
      SoCone pCone = new SoCone();
      pCone.height.setValue(coneHeight); // size[0] / 20;
      pCone.bottomRadius.setValue(size[1] / 50);

      m_XRoot.addChild(pPos);
      m_XRoot.addChild(pMat);
      m_XRoot.addChild(pRot);
      m_XRoot.addChild(pCyl);
      m_XRoot.addChild(pTran);
      m_XRoot.addChild(pCone);
    }

    if (m_YRoot == null) {
      m_YRoot = new SoSeparator();
      m_YRoot.setName("MISC_YGEOM");
      addChild(m_YRoot);
    } else
      m_YRoot.removeAllChildren();

    {
      SoMaterial pMat = new SoMaterial();
      pMat.diffuseColor.setValue(new SbColor(0, 1, 0));
      SoCylinder pCyl = new SoCylinder();
      pCyl.height.setValue(size[1]);
      pCyl.radius.setValue(size[0] / 100);
      SoTranslation pTran = new SoTranslation();
      pTran.translation.setValue(new SbVec3f(0, (size[1]/2 + coneHeight/2), 0));
      SoCone pCone = new SoCone();
      pCone.height.setValue(coneHeight); // size[1] / 20;
      pCone.bottomRadius.setValue(size[0] / 50);

      m_YRoot.addChild(pPos);
      m_YRoot.addChild(pMat);
      m_YRoot.addChild(pCyl);
      m_YRoot.addChild(pTran);
      m_YRoot.addChild(pCone);
    }

    if (m_ZRoot == null) {
      m_ZRoot = new SoSeparator();
      m_ZRoot.setName("MISC_ZGEOM");
      addChild(m_ZRoot);
    } else
      m_ZRoot.removeAllChildren();

    {
      SoMaterial pMat = new SoMaterial();
      pMat.diffuseColor.setValue(new SbColor(0, 0, 1));
      SoRotation pRot = new SoRotation();
      pRot.rotation.setValue(new SbRotation(new SbVec3f(1, 0, 0), VolRend.PIO2));
      SoCylinder pCyl = new SoCylinder();
      pCyl.height.setValue(size[2]);
      pCyl.radius.setValue(size[1] / 100);
      SoTranslation pTran = new SoTranslation();
      pTran.translation.setValue(new SbVec3f(0, (size[2]/2 + coneHeight/2), 0));
      SoCone pCone = new SoCone();
      pCone.height.setValue(coneHeight); // size[2] / 20;
      pCone.bottomRadius.setValue(size[1] / 50);

      m_ZRoot.addChild(pPos);
      m_ZRoot.addChild(pMat);
      m_ZRoot.addChild(pRot);
      m_ZRoot.addChild(pCyl);
      m_ZRoot.addChild(pTran);
      m_ZRoot.addChild(pCone);
    }
  }
}
