package volumeviz.advanced.volRend;

import javax.swing.*;
import java.awt.*;
import javax.swing.border.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.io.*;

public class VolRendParamFrame extends JFrame {

  private VolRend m_volRend;

  private JSplitPane m_mainSplitPane = new JSplitPane();
  private JSplitPane m_paramSplitPane = new JSplitPane();
  private MessageTextPane m_messagePane = new MessageTextPane();
  private JTree m_paramTree;
  private JPanel m_paramPanel;

  public VolRendParamFrame(VolRend volrend) {
    m_volRend = volrend;
    System.setErr(new PrintStream(new VolRendOutputStream(m_messagePane, true), true));
    System.setOut(new PrintStream(new VolRendOutputStream(m_messagePane, false), true));

    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }

    Toolkit.getDefaultToolkit().setDynamicLayout(true);
    setTitle("VolumeViz Example");
    pack();
    
    // Check if init data have been loaded
    File f = new File(m_volRend.m_volData.fileName.getValue());
    if(!f.exists())
      System.err.println("Inventor error: SoVolumeData: Unable to load data. Check file location");
  }

  private void jbInit() throws Exception {
    // Param panel
    m_paramPanel = new JPanel();
    m_paramPanel.setPreferredSize(new Dimension(475, 400));
    m_paramPanel.setLayout(new BorderLayout());
    m_paramPanel.addContainerListener(new ContainerAdapter() {
      public void componentAdded(ContainerEvent e) {
        // update look and feel
        //SwingUtilities.updateComponentTreeUI(e.getChild());
      }
    });
    JScrollPane params_pane = new JScrollPane(m_paramPanel);

    // Param tree
    makeParamTree();
    JScrollPane tree_pane = new JScrollPane(m_paramTree);

    m_paramSplitPane.add(tree_pane, JSplitPane.LEFT);
    m_paramSplitPane.add(params_pane, JSplitPane.RIGHT);
    m_paramSplitPane.setContinuousLayout(true);
    m_paramSplitPane.setOneTouchExpandable(true);

    // Message edit pane
    m_messagePane.setEditable(false);
    JScrollPane message_pane = new JScrollPane(m_messagePane);
    message_pane.setBorder(new TitledBorder(new EtchedBorder(), "Messages"));
    message_pane.setPreferredSize(new Dimension(700, 150));

    m_mainSplitPane.setOrientation(JSplitPane.VERTICAL_SPLIT);
    m_mainSplitPane.setContinuousLayout(true);
    m_mainSplitPane.setOneTouchExpandable(true);
    m_mainSplitPane.add(m_paramSplitPane, JSplitPane.TOP);
    m_mainSplitPane.add(message_pane, JSplitPane.BOTTOM);

    // Exit Button
    JButton exit_button = new JButton("Exit VolRend");
    exit_button.addMouseListener(new MouseAdapter() {
      public void mousePressed(MouseEvent e) {
        Container f = m_volRend.m_viewer.getComponent().getParent();
        while(f.getParent()!=null) f=f.getParent();
        (((Frame)f).getWindowListeners())[0].windowClosing(new WindowEvent((Frame)f, WindowEvent.WINDOW_CLOSING));
      }
    });

    this.getContentPane().add(m_mainSplitPane, BorderLayout.CENTER);
    this.getContentPane().add(exit_button, BorderLayout.SOUTH);
  }

  private void makeParamTree() {
    DefaultMutableTreeNode root = new DefaultMutableTreeNode("");
    m_paramTree = new JTree(root);

    // Decoration
    DefaultMutableTreeNode deco_leaf = new DefaultMutableTreeNode
        (new ParamNode("Decoration", new DecorationPanel(m_volRend, this)));

    // Volume Rendering
    DefaultMutableTreeNode volume_rendering_node = new DefaultMutableTreeNode
        (new ParamNode("Volume Rendering", new VolumeRenderPanel(m_volRend)));
    VolumeColormapPanel vol_colormap_panel = new VolumeColormapPanel(m_volRend);
    DefaultMutableTreeNode volume_colormap_leaf = new DefaultMutableTreeNode
        (new ParamNode("Volume ColorMap", vol_colormap_panel));
    DefaultMutableTreeNode texture_leaf = new DefaultMutableTreeNode
        (new ParamNode("Texture", new TexturePanel(m_volRend)));
    GeomControlPanel geom_control_panel =  new GeomControlPanel(m_volRend);
    DefaultMutableTreeNode geom_control_leaf = new DefaultMutableTreeNode
        (new ParamNode("Geometry Control", geom_control_panel));
    DefaultMutableTreeNode material_lighting_leaf = new DefaultMutableTreeNode
        (new ParamNode("Material and Lighting", new MatAndLightPanel(m_volRend)));

    // Geometry Control
    DefaultMutableTreeNode geom_control_node = new DefaultMutableTreeNode
        (new ParamNode("Geometry Control", null));
    SliceColormapPanel slice_colormap_panel = new SliceColormapPanel(m_volRend);
    DefaultMutableTreeNode slice_colormap_leaf = new DefaultMutableTreeNode
        (new ParamNode("Slice ColorMap", slice_colormap_panel));
    ParamNode ortho_slice = new ParamNode("Ortho Slice");
    DefaultMutableTreeNode ortho_slice_node = new DefaultMutableTreeNode(ortho_slice);
    MainOrthoSlicesPanel ortho_slices_panel = new MainOrthoSlicesPanel
        (m_volRend, m_paramTree, ortho_slice_node);
    ortho_slice.setPanel(ortho_slices_panel);
    ObliqueSlicePanel obli_slice_panel = new ObliqueSlicePanel(m_volRend.m_sliceGroup);
    DefaultMutableTreeNode oblique_slice_node = new DefaultMutableTreeNode
        (new ParamNode("Oblique Slice", obli_slice_panel));
    DefaultMutableTreeNode vol_geom_leaf = new DefaultMutableTreeNode
        (new ParamNode("Volume Geometry Node", new VolGeomNodePanel(m_volRend.m_sliceGroup)));

    // ROI
    ROIPanel roi_panel = new ROIPanel(m_volRend);
    DefaultMutableTreeNode roi_leaf = new DefaultMutableTreeNode
        (new ParamNode("Region of Interest", roi_panel));

    // LDM control
    DefaultMutableTreeNode ldm_node = new DefaultMutableTreeNode
        (new ParamNode("LDM Control", null));
    DefaultMutableTreeNode feedback_leaf = new DefaultMutableTreeNode
        (new ParamNode("Visual Feedback", new VisualFeedbackPanel(m_volRend.m_volData)));
    LDMOptionsPanel ldm_options_panel =  new LDMOptionsPanel(m_volRend.m_volData);
    DefaultMutableTreeNode options_leaf = new DefaultMutableTreeNode
        (new ParamNode("Options", ldm_options_panel));
    DefaultMutableTreeNode memory_leaf = new DefaultMutableTreeNode
        (new ParamNode("Main Memory Control Parameters", new MemControlPanel(m_volRend.m_volData)));
    DefaultMutableTreeNode vol_texturing_leaf = new DefaultMutableTreeNode
        (new ParamNode("Control Parameter for Volume Texturing", new VolTextControlPanel(m_volRend.m_volData)));
    DefaultMutableTreeNode slices_texturing_leaf = new DefaultMutableTreeNode
        (new ParamNode("Control Parameter for Slices Texturing", new SlicesTextControlPanel(m_volRend.m_volData)));

    VolRendPanel[] panels = {
        vol_colormap_panel,
        slice_colormap_panel,
        geom_control_panel,
        ortho_slices_panel,
        obli_slice_panel,
        roi_panel,
        ldm_options_panel
    };
    // DataSet
    DefaultMutableTreeNode dataSet_leaf =
        new DefaultMutableTreeNode
        (new ParamNode("DataSet",
                       new DataSetPanel(m_volRend, panels)));

    volume_rendering_node.add(volume_colormap_leaf);
    volume_rendering_node.add(texture_leaf);
    volume_rendering_node.add(geom_control_leaf);
    volume_rendering_node.add(material_lighting_leaf);
    geom_control_node.add(slice_colormap_leaf);
    geom_control_node.add(ortho_slice_node);
    geom_control_node.add(oblique_slice_node);
    geom_control_node.add(vol_geom_leaf);
    ldm_node.add(feedback_leaf);
    ldm_node.add(options_leaf);
    ldm_node.add(memory_leaf);
    ldm_node.add(vol_texturing_leaf);
    ldm_node.add(slices_texturing_leaf);

    root.add(dataSet_leaf);
    root.add(deco_leaf);
    root.add(volume_rendering_node);
    root.add(geom_control_node);
    root.add(roi_leaf);
    root.add(ldm_node);

    for (int i = 0; i < m_paramTree.getRowCount(); i++)
      m_paramTree.expandRow(i);
    m_paramTree.addTreeSelectionListener(new ParamTreeSelectionListener());
    m_paramTree.setSelectionRow(1);
    m_paramTree.setCellRenderer(new ParamTreeCellRenderer());
  }

  class ParamTreeSelectionListener implements TreeSelectionListener {
    public void valueChanged(TreeSelectionEvent e) {
     DefaultMutableTreeNode selected = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
     ParamNode pn = (ParamNode)selected.getUserObject();
     m_paramPanel.removeAll();
     JPanel node_panel = pn.getPanel();
     if (node_panel != null)
       m_paramPanel.add(node_panel, BorderLayout.CENTER);
     else {
       m_paramTree.setSelectionPath(new TreePath(((DefaultMutableTreeNode)selected.getFirstChild()).getPath()));
     }

      m_paramPanel.getParent().validate();
      m_paramPanel.getParent().repaint();
    }
  }

  /********* DirTreeCellRenderer class *********/
  class ParamTreeCellRenderer extends JLabel implements TreeCellRenderer {

    private final Color BK_COLOR = new Color(204, 204, 255);
    private final Color m_textColor = UIManager.getColor("Tree.TextForeground");

    protected boolean m_selected;

    public ParamTreeCellRenderer() {
      super();
      setOpaque(false);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value,
                                                  boolean sel, boolean expanded,
                                                  boolean leaf, int row, boolean hasFocus) {
      DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
      Object obj = node.getUserObject();
      setText(obj.toString());
      Font tree_font = m_paramTree.getFont();
      if(node.getParent() != null && node.getParent().getParent() != null)
        setFont(tree_font);
      else
        setFont(new Font(tree_font.getName(), Font.BOLD, tree_font.getSize()));
      setForeground(m_textColor);
      m_selected = sel;
      return this;
    }

    public void paintComponent(Graphics g) {
      if (m_selected) {
        // draw selection rectangle
        g.setColor(BK_COLOR);
        g.fillRect(0, 0, getWidth(), getHeight());
      }
      super.paintComponent(g);
    }
  }
}
