package volumeviz.advanced.volRend; 

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;

public class VolumeColormapPanel extends ColormapPanel {

  private VolRend m_volRend;

  public VolumeColormapPanel(VolRend vol_rend) {
    super("VOLUME COLORMAP", 0);

    m_volRend = vol_rend;

    m_colormapChooser.addComboBoxListener(new VolCmapComboBoxListener());
    m_colormapMin.addSliderPanelListener(new ColormapMinSliderListener());
    m_colormapMax.addSliderPanelListener(new ColormapMaxSliderListener());
    m_opaqueMin.addSliderPanelListener(new OpaqueMinSliderListener());
    m_opaqueMax.addSliderPanelListener(new OpaqueMaxSliderListener());
    m_invert.addItemListener(new InvertListener());
  }

  private void updateMap() {
    m_volRend.m_transferFunction.minValue.setValue(VolRend.m_minColorMap);
    m_volRend.m_transferFunction.maxValue.setValue(VolRend.m_maxColorMap);
    m_volRend.m_transferFunction.touch();

    m_volRend.updateOpaqueRegion(m_volRend.m_transferFunction,
                                 VolRend.m_minOpaqueMap,
                                 VolRend.m_maxOpaqueMap,
                                 VolRend.m_invertTransparency);
    m_volRend.m_infoSep.createHistoLegend(0);
  }

  class VolCmapComboBoxListener implements ChooserComboBoxListener {
    public void itemSelectedChanged(int selected_index) {
      if (selected_index == m_comboBoxItems.length - 1)
        m_volRend.m_userColorMapName = m_colormapChooser.getUserFile().getAbsolutePath();
      m_volRend.doCmapChange(selected_index, m_volRend.m_transferFunction);
    }
  }

  class ColormapMinSliderListener extends SliderPanel.Listener {
    public void stateChanged(float value) {
      if (value > VolRend.m_maxColorMap)
        System.err.println("Colormap Max < Colormap Min : impossible");
      else {
        // Remap colormap, then re-apply min/max opaque values
        VolRend.m_minColorMap = (int)value;
        updateMap();
      }
    }
  }

  class ColormapMaxSliderListener extends SliderPanel.Listener {
    public void stateChanged(float value) {
      if (value < VolRend.m_minColorMap)
        System.err.println("Colormap Max < Colormap Min : impossible");
      else {
        // Remap colormap, then re-apply min/max opaque values
        VolRend.m_maxColorMap = (int)value;
        updateMap();
      }
    }
  }

  class OpaqueMinSliderListener extends SliderPanel.Listener {
    public void stateChanged(float value) {
      if (value > VolRend.m_maxOpaqueMap)
        System.err.println("Opaque Max < Opaque Min : impossible");
      else {
        // Remap colormap, then re-apply min/max opaque values
        VolRend.m_minOpaqueMap = (int)value;
        updateMap();
      }
    }
  }

  class OpaqueMaxSliderListener extends SliderPanel.Listener {
    public void stateChanged(float value) {
      if (value < VolRend.m_minOpaqueMap)
        System.err.println("Opaque Max < Opaque Min : impossible\n");
      else {
        // Remap colormap, then re-apply min/max opaque values
        VolRend.m_maxOpaqueMap = (int)value;
        updateMap();
      }
    }
  }

  class InvertListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      VolRend.m_invertTransparency = (e.getStateChange() == ItemEvent.SELECTED);
      updateMap();
    }
  }
}
