package volumeviz.advanced.volRend;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.JCheckBox;
import javax.swing.JPanel;

import com.openinventor.inventor.SbVec2s;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbVec3i32;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.SoPickedPoint;
import com.openinventor.inventor.actions.SoRayPickAction;
import com.openinventor.inventor.events.SoEvent;
import com.openinventor.inventor.events.SoLocation2Event;
import com.openinventor.inventor.events.SoMouseButtonEvent;
import com.openinventor.inventor.misc.callbacks.SoEventCallbackCB;
import com.openinventor.inventor.nodes.*;
import com.openinventor.volumeviz.details.SoObliqueSliceDetail;
import com.openinventor.volumeviz.details.SoOrthoSliceDetail;
import com.openinventor.volumeviz.details.SoVolumeDetail;
import com.openinventor.volumeviz.details.SoVolumeDetail.ProfileValue;
import com.openinventor.volumeviz.details.SoVolumeRenderDetail;
import com.openinventor.volumeviz.nodes.SoObliqueSlice;
import com.openinventor.volumeviz.nodes.SoOrthoSlice;
import com.openinventor.volumeviz.nodes.SoVolumeRender;

public class VolumeRenderPanel extends VolRendPanel {

  private VolRend m_volRend;

  public VolumeRenderPanel(VolRend vol_rend) {
    super("VOLUME RENDERING");
    m_volRend = vol_rend;

    try {
      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    JCheckBox visibility = new JCheckBox("Visibility", true);
    visibility.addItemListener(new VisibilityListener());
    JCheckBox probe = new JCheckBox("Probe", false);
    probe.addItemListener(new ProbeItemListener());

    GridLayout layout = new GridLayout(3, 1);
    layout.setVgap(10);
    JPanel main = new JPanel(layout);
    main.add(visibility);
    main.add(probe);

    setLayout(new BorderLayout());
    add(main, BorderLayout.NORTH);
  }

  class VisibilityListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      if (e.getStateChange() == ItemEvent.SELECTED)
        m_volRend.m_volRenderSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
      else if (e.getStateChange() == ItemEvent.DESELECTED)
        m_volRend.m_volRenderSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
    }
  }

  class ProbeItemListener implements ItemListener {
    private MouseMoveEventCB m_mouseMoveEventCB = new MouseMoveEventCB();
    private MouseKeyEventCB m_mouseKeyEventCB = new MouseKeyEventCB();
    private boolean leftMousePressed = false;
    private boolean leftMouseReleased = false;

    public void itemStateChanged(ItemEvent e) {
      if (e.getStateChange() == ItemEvent.SELECTED) {
        if (m_volRend.m_profileView == null) {
          Container f = m_volRend.m_viewer.getComponent().getParent();
          while(f.getParent()!=null) f=f.getParent();

          m_volRend.m_profileView = new VolRendProfView((Frame) f);
        }
        m_volRend.m_sliceGroup.m_switchForOrthoDragger.whichChild.setValue
            (SoSwitch.SO_SWITCH_NONE);
      }
      else
        m_volRend.m_sliceGroup.m_switchForOrthoDragger.whichChild.setValue
            (SoSwitch.SO_SWITCH_ALL);

      if (m_volRend.m_profileView.isVisibleProfile()) {
        m_volRend.m_mouseMoveEvent.removeEventCallback(SoLocation2Event.class,
                                                       m_mouseMoveEventCB, null);
        m_volRend.m_mouseKeyEvent.removeEventCallback(SoMouseButtonEvent.class,
                                                      m_mouseKeyEventCB, null);
        if (m_volRend.m_textSwitch != null)
          m_volRend.m_textSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
        m_volRend.m_profileView.hideProfile();
        // Note picking on the data overrides picking on the ROI dragger
        m_volRend.m_volRenderSwitch.m_pick.style.setValue(SoPickStyle.Styles.UNPICKABLE);
        m_volRend.m_volRenderSwitch.m_volROIPickStyle.style.setValue(SoPickStyle.Styles.SHAPE);
      } else {
        m_volRend.m_volRenderSwitch.m_pick.style.setValue(SoPickStyle.Styles.SHAPE);
        m_volRend.m_volRenderSwitch.m_volROIPickStyle.style.setValue(SoPickStyle.Styles.UNPICKABLE);
        m_volRend.m_profileView.showProfile();
        m_volRend.m_mouseMoveEvent.addEventCallback(SoLocation2Event.class,
                                                    m_mouseMoveEventCB, null);
        m_volRend.m_mouseKeyEvent.addEventCallback(SoMouseButtonEvent.class,
                                                   m_mouseKeyEventCB, null);
        if (m_volRend.m_textSwitch != null)
          m_volRend.m_textSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
      }
    }

    ///////////////////////////////////////////////////////////////////////
    // This routine is called for every mouse movement.
    class MouseMoveEventCB extends SoEventCallbackCB {
      private SbVec3f[] m_profile;
      private SoLineSet m_profileLineSet;
      private SoVertexProperty m_profileVertexProperty;
      private SoText2 m_volText2 = null;
      private SoText2 m_orthoText2 = null;
      private SoText2 m_obliqueText2 = null;
      private SoVertexProperty m_traceVertexProperty = null;
      private SoLineSet m_lineSet;

      private boolean m_flag = true;
      private boolean m_flagVolumeRender = false;

      public void invoke(SoEventCallback eventCB) {
        SoEvent event = eventCB.getEvent();
        SoPickedPoint picked_point;

        if (leftMousePressed) {
          // SoRayPickAction to get point in the scene graph.
          SoRayPickAction picked_action =
              new SoRayPickAction(new SbViewportRegion(m_volRend.m_viewer.getRenderArea().getComponent().getSize()));
          SbVec2s myVec2s = event.getPosition();
          picked_action.setPoint(myVec2s);
          picked_action.apply(m_volRend.m_root);
          picked_point = picked_action.getPickedPoint(0);
          if (picked_point != null) { // There is something.
            SoNode selected_node = (picked_point.getPath()).regular.getTail();
            SoSeparator profileRoot = m_volRend.m_profileView.getProfileRoot();

            if (selected_node instanceof SoVolumeRender) {
              for (int i = picked_point.getPath().full.getLength()-1; i >= 0;
                   i--) {}
              SoVolumeRenderDetail volumeRenderDetail = (SoVolumeRenderDetail)picked_point.getDetail();
              int numValues = volumeRenderDetail.getProfileNumValues();
              m_profile = volumeRenderDetail.getProfileObjectPos();

              if (m_flag) {
                // The m_profile
                m_profileVertexProperty = new SoVertexProperty();
                m_profileLineSet = new SoLineSet();
                m_profileLineSet.vertexProperty.setValue(m_profileVertexProperty);
                m_profileVertexProperty.orderedRGBA.setValue(0x00FF00FF);
                profileRoot.addChild(m_profileLineSet);
                if (m_volRend.m_infoSep.m_showHistogram)
                  m_volRend.m_volData.getDoubleMinMax();
              }

              SbVec3i32[] pos = new SbVec3i32[numValues];
              SbVec3f[] objPos = new SbVec3f[numValues];

              SbVec3f[] curve = new SbVec3f[numValues];
              for (int j = 0; j < numValues; j++) 
              {
              	ProfileValue profileValue = volumeRenderDetail.getProfileValue(j, false);
                float yValue = (float) profileValue.voxelValue;
                pos[j] = profileValue.pos;
                objPos[j] = profileValue.objPos;
                curve[j] = new SbVec3f();

                if (yValue > 255)
                  curve[j].setValue((float)j, yValue/255, 1.5f); // 16 Bits.
                else
                  curve[j].setValue((float)j, yValue, 1.5f); // 8 Bits
              }
              m_profileLineSet.numVertices.setValue(numValues);
              m_profileVertexProperty.vertex.setValues(0, curve);
              if (m_flag && m_volRend.m_newFile) {
                m_volRend.m_profileView.profileViewAll();
                m_flag = false;
              }
              m_flagVolumeRender = true;

              if ( m_volText2 == null )
              {
                SoSeparator textSep = m_volRend.m_profileView.getTextProfileRoot();

                SoSeparator localSep = new SoSeparator();
                textSep.addChild(localSep);
                SoFont pFont = new SoFont();
                SoTranslation pTran = new SoTranslation();
                pTran.translation.setValue(new SbVec3f( -.9f, 0.0f, 0.49f));
                pFont.size.setValue(12);
                localSep.addChild(pTran);
                localSep.addChild(pFont);
                m_volText2 = new SoText2();
                localSep.addChild(m_volText2);
              }

              SoVolumeDetail.TransparentLongValue packedValue = volumeRenderDetail.getFirstNonTransparentValue(false);
              if (packedValue != null) {
                String s = "Volume = "+ packedValue.value + " at (" + packedValue.objPos.getX() + ", "
                    + packedValue.objPos.getY() + ", " + packedValue.objPos.getZ() + ")";
                m_volText2.string.setValue(s);
              }
              else
                m_volText2.string.setValue("Volume = <transparent>");
            }

            if (selected_node instanceof SoOrthoSlice) {
              SoOrthoSliceDetail orthoSliceDetail = (SoOrthoSliceDetail)
                  picked_point.getDetail();

              if (m_orthoText2 == null) {
                SoSeparator textSep = m_volRend.m_profileView.getTextProfileRoot();
                SoSeparator localSep = new SoSeparator();
                textSep.addChild(localSep);
                SoFont pFont = new SoFont();
                SoTranslation pTran = new SoTranslation();
                pTran.translation.setValue(new SbVec3f( -.9f, -.8f, 0.49f));
                pFont.size.setValue(12);
                localSep.addChild(pTran);
                localSep.addChild(pFont);
                m_orthoText2 = new SoText2();
                localSep.addChild(m_orthoText2);
              }
              SbVec3i32 pos = orthoSliceDetail.getValueDataPos();
              String s = "Ortho Slice = " +orthoSliceDetail.getValue() + "at ("
                  + pos.getX()+ ", " + pos.getY() + ", " + pos.getZ()+ ")";
              m_orthoText2.string.setValue(s);
            }

            if (selected_node instanceof SoObliqueSlice) {
              SoObliqueSliceDetail obliqueSliceDetail = (SoObliqueSliceDetail)
                  picked_point.getDetail();

              if (m_obliqueText2 == null) {
                SoSeparator textSep = m_volRend.m_profileView.getTextProfileRoot();
                SoSeparator localSep = new SoSeparator();
                textSep.addChild(localSep);
                SoFont pFont = new SoFont();
                SoTranslation pTran = new SoTranslation();
                pTran.translation.setValue(new SbVec3f( -0.9f, 0.8f, 0.49f));
                pFont.size.setValue(12);
                localSep.addChild(pTran);
                localSep.addChild(pFont);
                m_obliqueText2 = new SoText2();
                localSep.addChild(m_obliqueText2);
              }
              SbVec3i32 pos = obliqueSliceDetail.getValueDataPos();
              String s = "Oblique Slice = " +obliqueSliceDetail.getValue() + "at ("
                  + pos.getX()+ ", " + pos.getY() + ", " + pos.getZ()+ ")";
              m_obliqueText2.string.setValue(s);
            }
          }
        }

        else {
          if (leftMouseReleased && m_flagVolumeRender) {
            m_flagVolumeRender = false;
            if (m_traceVertexProperty == null) { //|| m_newFile ) {
              m_volRend.m_textSwitch = new SoSwitch();
              m_volRend.m_textSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
              m_lineSet = new SoLineSet();
              m_volRend.m_textSwitch.addChild(m_lineSet);
              m_volRend.m_root.insertChild(m_volRend.m_textSwitch, 1);
              m_traceVertexProperty = new SoVertexProperty();
              m_traceVertexProperty.orderedRGBA.setValue(0xFFFF00FF);
              m_lineSet.vertexProperty.setValue(m_traceVertexProperty);
              m_volRend.m_newFile = false;
            }
            if (m_volRend.m_newFile)
              m_volRend.m_textSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
            m_traceVertexProperty.vertex.setValues(0, m_profile);
            m_lineSet.numVertices.setValue(2);
          }
        }
      }
    }

    ///////////////////////////////////////////////////////////////////////
    // This routine is called for every mouse movement.
    class MouseKeyEventCB extends SoEventCallbackCB {
      private SbVec2s downPos = new SbVec2s((short)0, (short)0);

      public void invoke(SoEventCallback eventCB) {
        SoEvent event = eventCB.getEvent();

        // Check for mouse button being pressed
        if (SoMouseButtonEvent.isButtonPressEvent(event, SoMouseButtonEvent.Buttons.ANY)) {
          leftMousePressed = true;
          downPos = event.getPosition();
          eventCB.setHandled();
        }
        else {
          if (SoMouseButtonEvent.isButtonReleaseEvent(event, SoMouseButtonEvent.Buttons.ANY))
            leftMouseReleased = true;
          else
            leftMouseReleased = false;

          // If user just clicked, then no motion event occured, but we
          // still want to pick (at least on slices).      mmh Dec-2000
          // Do this *before* resetting m_leftMousePressed...
          SbVec2s upPos = event.getPosition();
          if (upPos.equals(downPos)) {
            m_mouseMoveEventCB.invoke(eventCB);
          }
          leftMousePressed = false;
        }
      }
    }
  }
}
