package volumeviz.sample.ambientOcclusion;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;

import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.actions.SoGLRenderAction;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

/**
 * A simple sceneGraph showing how to use ambient occlusion combined with
 * BOUNDARY_ALIGNED sampling method.
 *
 */
public class Main extends Example
{

  private IViewerExaminer myViewer;

  @Override
  public void start()
  {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setTransparencyType(SoGLRenderAction.TransparencyTypes.NO_SORT);

    String pkgName = this.getClass().getPackage().getName();
    pkgName = pkgName.replace('.', File.separatorChar);
    String filePrefix = SoPreferences.getValue("OIVJHOME") + File.separator + "examples" + File.separator + pkgName
        + File.separator;

    SoSeparator root = new SoSeparator();
    SoNode node = readSceneGraph(filePrefix + "ambientOcclusion.iv");
    root.addChild(node);
    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  private static SoNode readSceneGraph(String fileName)
  {
    SoInput input = new SoInput();

    if ( !input.openFile(fileName) )
    {
      System.err.println("Cannot open file " + fileName);
      return null;
    }

    SoSeparator node = SoDB.readAll(input);
    if ( node == null )
    {
      System.err.println("Problem reading file");
      input.closeFile();
      return null;
    }

    input.closeFile();
    return node;
  }

  public static void main(String[] args)
  {
    Main example = new Main();
    example.demoMain("Ambient occlusion");
  }

}
