// Fragment shader for AmplitudeVelocity example
// Take intensity value from volume1 (seismic amplitude)
// and color value from volume2 (velocity model)

//!oiv_include <VolumeViz/vvizGetData_frag.h>
//!oiv_include <VolumeViz/vvizTransferFunction_frag.h>
//!oiv_include <VolumeViz/vvizfnc_frag.h>

uniform VVizDataSetId dataVelocity;
uniform VVizDataSetId dataAmplitude;
uniform float combinedPercentage;

float cj(in float a)
{
  return 1.0 - a;
}

float pow2(in float x, in float y)
{
  return mix(pow(x, y), 1.0, (x == 0.0) && (y == 0.0));
}

vec4 mixcolors(in vec4 c1, in vec4 c2, in float pct)
{
  return mix(vec4(mix(c1.rgb*c1.a, c2.rgb*c2.a, pct)/mix(c1.a , c2.a, pct), cj(pow2(cj(c1.a),1-pct) * pow2(cj(c2.a),pct))),
			 vec4(0.0),
			 mix(c1.a , c2.a, pct)==0.0);
}

vec4 blend(VVizDataSetId dataset, in vec3 texCoord)
{
  // Convert coordinates
  vec3 dataCoord1 = VVizTextureToTextureVec(dataset, dataVelocity, texCoord);
  vec3 dataCoord2 = VVizTextureToTextureVec(dataset, dataAmplitude, texCoord);

  // Get data and apply TransferFunction
  // Make sure we return vec4(0.0) outside volume
  vec4 data1Color = mix(VVizTransferFunction(VVizGetData(dataVelocity, dataCoord1), dataVelocity), vec4(0.0), bvec4(VVizIsOutsideVolume(dataCoord1)));
  vec4 data2Color = mix(VVizTransferFunction(VVizGetData(dataAmplitude, dataCoord2), dataAmplitude), vec4(0.0), bvec4(VVizIsOutsideVolume(dataCoord2)));

  // Do not mix outside volumes intersection
  float finalCombinedPercentage = mix(mix(combinedPercentage, 1.0, VVizIsOutsideVolume(dataCoord1)), 0.0, VVizIsOutsideVolume(dataCoord2));

  return mixcolors(data1Color, data2Color, finalCombinedPercentage);
}

// Implement VVizComputeFragmentColor for slice nodes
vec4 VVizComputeFragmentColor(VVIZ_DATATYPE vox, vec3 texCoord)
{
  return blend(VVizGetDefaultDataSet(), texCoord);
}

// Implement VVizComputeFragmentColor for SoVolumeRender
vec4 VVizComputeFragmentColor(in VVizDataSetId dataset, in vec3 rayDir, inout VVizVoxelInfo voxelInfoFront, in VVizVoxelInfo voxelInfoBack, in int maskId)
{
  return blend(dataset, voxelInfoFront.texCoord);
}
