package volumeviz.sample.amplitudeVelocity;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import com.openinventor.inventor.SbBox3f;
import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbDataType;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbVec3i32;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.SoSceneManager.AntialiasingModes;
import com.openinventor.inventor.actions.SoGLRenderAction.TransparencyTypes;
import com.openinventor.inventor.draggers.SoTabBoxDragger;
import com.openinventor.inventor.fields.SoSFArray;
import com.openinventor.inventor.nodes.SoBaseColor;
import com.openinventor.inventor.nodes.SoCube;
import com.openinventor.inventor.nodes.SoDrawStyle;
import com.openinventor.inventor.nodes.SoFile;
import com.openinventor.inventor.nodes.SoFragmentShader;
import com.openinventor.inventor.nodes.SoGradientBackground;
import com.openinventor.inventor.nodes.SoLightModel;
import com.openinventor.inventor.nodes.SoPickStyle;
import com.openinventor.inventor.nodes.SoScale;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoShaderParameter1f;
import com.openinventor.inventor.nodes.SoShaderParameter1i;
import com.openinventor.inventor.nodes.SoSwitch;
import com.openinventor.inventor.nodes.SoTransformSeparator;
import com.openinventor.inventor.nodes.SoTranslation;
import com.openinventor.inventor.viewercomponents.awt.IRenderAreaInteractive;
import com.openinventor.inventor.viewercomponents.nodes.SceneOrbiter;
import com.openinventor.inventor.viewercomponents.nodes.SoViewingCube;
import com.openinventor.ldm.nodes.SoMultiDataSeparator;
import com.openinventor.ldm.nodes.SoTransferFunction;
import com.openinventor.volumeviz.nodes.SoOrthoSlice;
import com.openinventor.volumeviz.nodes.SoVolumeData;
import com.openinventor.volumeviz.nodes.SoVolumeRender;
import com.openinventor.volumeviz.nodes.SoVolumeRenderingQuality;
import com.openinventor.volumeviz.nodes.SoVolumeShader;
import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private IRenderAreaInteractive m_viewer;
  private SoShaderParameter1f m_combinedPercentageShaderParam;
  private SoVolumeRender m_vRender;
  private SoSwitch m_volumeSwitch;
  private SoTransferFunction m_pTransFunc1;
  private SoTransferFunction m_pTransFunc2;

  private JCheckBox m_velocitySliceChb;
  private JSlider m_velocitySliceSlider;
  private JCheckBox m_velocityVrChb;
  private SoOrthoSlice m_orthoVelocitySlice;
  private SoSwitch m_orthoVelocitySwitch;

  private JCheckBox m_amplitudeSliceChb;
  private JSlider m_amplitudeSliceSlider;
  private JCheckBox m_amplitudeVrChb;
  private SoOrthoSlice m_orthoAmplitudeSlice;
  private SoSwitch m_orthoAmplitudeSwitch;

  private JSlider m_combineSlider;

  private final int AMPLITUDE_ID = 1;
  private final int VELOCITY_ID = 2;

  @Override
  public void start()
  {

    // Scene Graph
    SoSeparator root = new SoSeparator();

    final float grayVal = 0.99f;
    final SbColor BKG_COLOR = new SbColor(grayVal, grayVal, grayVal);
    SoGradientBackground gradientBackground = new SoGradientBackground();
    gradientBackground.color0.setValue(BKG_COLOR);
    gradientBackground.color1.setValue(BKG_COLOR);
    root.addChild(gradientBackground);

    SoMultiDataSeparator mds = new SoMultiDataSeparator();
    root.addChild(mds);

    SoTransformSeparator tfs1 = new SoTransformSeparator();
    mds.addChild(tfs1);

    SoVolumeData volData1 = new SoVolumeData();
    tfs1.addChild(volData1);
    volData1.fileName.setValue("$OIVJHOME/data/volumeviz/colt-float.ldm");
    volData1.dataSetId.setValue(AMPLITUDE_ID);
    volData1.extent.setValue(new SbVec3f(-1.0f, -1.0f, -1.0f), new SbVec3f(1.0f, 1.0f, 1.0f));

    m_pTransFunc1 = new SoTransferFunction();
    tfs1.addChild(m_pTransFunc1);
    m_pTransFunc1.predefColorMap.setValue(SoTransferFunction.PredefColorMaps.INTENSITY);
    m_pTransFunc1.transferFunctionId.connectFrom(volData1.dataSetId);

    SoTransformSeparator tfs2 = new SoTransformSeparator();
    mds.addChild(tfs2);

    SoTabBoxDragger tbbDragger = new SoTabBoxDragger();
    tfs2.addChild(tbbDragger);

    SoBaseColor baseColor = new SoBaseColor();
    baseColor.rgb.setValue(new SbVec3f(0.0f, 0.5f, 0.0f));
    baseColor.setOverride(true);
    SoDrawStyle drawStyle = new SoDrawStyle();
    drawStyle.lineWidth.setValue(2.0f);
    drawStyle.style.setValue(SoDrawStyle.Styles.LINES);
    drawStyle.setOverride(true);

    // Dragger custom
    SoSeparator boxGeom = (SoSeparator) tbbDragger.getPart("boxGeom", true);
    boxGeom.insertChild(baseColor, 0);
    boxGeom.insertChild(drawStyle, 0);

    SoTranslation trans = new SoTranslation();
    tfs2.addChild(trans);

    SoScale scale = new SoScale();
    tfs2.addChild(scale);

    SoVolumeData volData2 = makeVelocityVolume(new SbVec3i32(150, 150, 150));
    tfs2.addChild(volData2);
    volData2.extent.setValue(new SbVec3f(-1.0f, -1.0f, -1.0f), new SbVec3f(1.0f, 1.0f, 1.0f));
    volData2.dataSetId.setValue(VELOCITY_ID);

    m_pTransFunc2 = new SoTransferFunction();
    tfs2.addChild(m_pTransFunc2);
    m_pTransFunc2.predefColorMap.setValue(SoTransferFunction.PredefColorMaps.STANDARD);
    m_pTransFunc2.transferFunctionId.connectFrom(volData2.dataSetId);

    SoFragmentShader fragmentShader = new SoFragmentShader();
    fragmentShader.sourceProgram
        .setValue("$OIVJHOME/examples/volumeviz/sample/amplitudeVelocity/AmplitudeVelocity_sliceFrag.glsl");

    SoShaderParameter1i data1 = new SoShaderParameter1i();
    data1.name.setValue("dataAmplitude");
    data1.value.setValue(AMPLITUDE_ID);
    fragmentShader.parameter.set1Value(0, data1);

    SoShaderParameter1i data2 = new SoShaderParameter1i();
    data2.name.setValue("dataVelocity");
    data2.value.setValue(VELOCITY_ID);
    fragmentShader.parameter.set1Value(1, data2);

    m_combinedPercentageShaderParam = new SoShaderParameter1f();
    m_combinedPercentageShaderParam.name.setValue("combinedPercentage");
    m_combinedPercentageShaderParam.value.setValue(0.5f);
    fragmentShader.parameter.set1Value(2, m_combinedPercentageShaderParam);

    SoVolumeRenderingQuality volRenderQuality = new SoVolumeRenderingQuality();
    volRenderQuality.shaderObject.set1Value(SoVolumeShader.ShaderPositions.FRAGMENT_COMPUTE_COLOR.getValue(),
        fragmentShader);
    mds.addChild(volRenderQuality);

    SoSeparator contVol = new SoSeparator();
    mds.addChild( contVol );

    SoPickStyle volumePickStyle = new SoPickStyle();
    volumePickStyle.style.setValue( SoPickStyle.Styles.UNPICKABLE );
    contVol.addChild( volumePickStyle );

    m_volumeSwitch = new SoSwitch();
    contVol.addChild(m_volumeSwitch);
    m_volumeSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
    m_vRender = new SoVolumeRender();
    m_volumeSwitch.addChild(m_vRender);

    SoVolumeShader volShader = new SoVolumeShader();
    volShader.shaderObject.set1Value(SoVolumeShader.ShaderPositions.FRAGMENT_COMPUTE_COLOR.getValue(), fragmentShader);
    mds.addChild(volShader);

    m_orthoAmplitudeSwitch = new SoSwitch();
    mds.addChild(m_orthoAmplitudeSwitch);
    m_orthoAmplitudeSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
    m_orthoAmplitudeSlice = new SoOrthoSlice();
    m_orthoAmplitudeSwitch.addChild(m_orthoAmplitudeSlice);
    m_orthoAmplitudeSlice.sliceNumber.setValue(32);
    m_orthoAmplitudeSlice.dataSetId.setValue(AMPLITUDE_ID);

    m_orthoVelocitySwitch = new SoSwitch();
    mds.addChild(m_orthoVelocitySwitch);
    m_orthoVelocitySwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
    m_orthoVelocitySlice = new SoOrthoSlice();
    m_orthoVelocitySwitch.addChild(m_orthoVelocitySlice);
    m_orthoVelocitySlice.sliceNumber.setValue(32);
    m_orthoVelocitySlice.dataSetId.setValue(VELOCITY_ID);

    root.addChild(CreateBBox(volData1.extent.getValue()));

    // Dragger Connection
    trans.translation.connectFrom(tbbDragger.translation);
    scale.scaleFactor.connectFrom(tbbDragger.scaleFactor);
    tbbDragger.translation.setValue(new SbVec3f(-0.5f, -0.5f, 0.0f));
    tbbDragger.scaleFactor.setValue(new SbVec3f(0.5f, 0.5f, 0.5f));

    // GUI
    m_viewer = ViewerComponentsFactory.createRenderAreaOrbiter();
    m_viewer.setAntialiasingMode(AntialiasingModes.FSAA);
    m_viewer.setTransparencyType(TransparencyTypes.SORTED_PIXEL);
    m_viewer.setAntialiasingQuality(1.0f);

    updateOpacity(m_pTransFunc1, 0.5f);
    updateOpacity(m_pTransFunc2, 0.5f);

    SceneOrbiter sceneOrbiter = (SceneOrbiter) m_viewer.getSceneInteractor();
    SoViewingCube viewingCube = sceneOrbiter.getViewingCube();
    viewingCube.edgeStyle.setValue(SoViewingCube.EdgeStyles.CORNER);

    viewingCube.size.setValue(new SbVec2f(200.0f, 200.0f));
    viewingCube.opacityMin.setValue(0.0f);
    viewingCube.opacityMax.setValue(0.8f);
    SoFile compass = new SoFile();
    compass.name.setValue("$OIVJHOME/data/examples/ViewingCube/Compass/compass-northsouth-y.iv");
    viewingCube.compass.setValue(compass);
    viewingCube.facePosX.setValue("$OIVJHOME/data/examples/ViewingCube/Faces/NSEW/xpos.png");
    viewingCube.faceNegX.setValue("$OIVJHOME/data/examples/ViewingCube/Faces/NSEW/xneg.png");
    viewingCube.facePosY.setValue("$OIVJHOME/data/examples/ViewingCube/Faces/NSEW/ypos.png");
    viewingCube.faceNegY.setValue("$OIVJHOME/data/examples/ViewingCube/Faces/NSEW/yneg.png");
    viewingCube.facePosZ.setValue("$OIVJHOME/data/examples/ViewingCube/Faces/NSEW/zpos.png");
    viewingCube.faceNegZ.setValue("$OIVJHOME/data/examples/ViewingCube/Faces/NSEW/zneg.png");

    setBackground(Color.white);
    setLayout(new BorderLayout());
    add(buildOptionsPanel(volData1.data.getSize(), volData2.data.getSize()), BorderLayout.NORTH);
    add(m_viewer.getComponent(), BorderLayout.CENTER);

    m_viewer.setSceneGraph(root);
    m_viewer.getComponent().setPreferredSize(new Dimension(1280, 720));

    m_viewer.setAntialiasingMode(AntialiasingModes.AUTO);
    m_viewer.setAntialiasingQuality(1);

    ((SceneOrbiter) m_viewer.getSceneInteractor()).enableViewingCube(true);
    m_viewer.viewAll(new SbViewportRegion());

  }

  private JPanel buildOptionsPanel(SbVec3i32 vol1Size, SbVec3i32 vol2Size)
  {
    JPanel panel = new JPanel();
    panel.setLayout(new FlowLayout(FlowLayout.LEFT, 5, 5));

    // Velocity
    JPanel velocityPanel = new JPanel();
    panel.add(velocityPanel);
    TitledBorder velocityBorder =
        BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.RED), "Velocity 150 x 150 x 150");
    velocityPanel.setBorder(velocityBorder);
    velocityPanel.setLayout(new BoxLayout(velocityPanel, BoxLayout.Y_AXIS));

    JPanel velocitySlicePanel = new JPanel();
    velocityPanel.add(velocitySlicePanel);
    velocitySlicePanel.setLayout(new FlowLayout(FlowLayout.LEFT));
    ((FlowLayout) velocitySlicePanel.getLayout()).setHgap(0);
    velocitySlicePanel.setAlignmentX(Component.LEFT_ALIGNMENT);

    m_velocitySliceChb = new JCheckBox("slice");
    m_velocitySliceChb.setSelected(true);
    velocitySlicePanel.add(m_velocitySliceChb);

    m_velocitySliceSlider = new JSlider(0, 150, 32);
    velocitySlicePanel.add(m_velocitySliceSlider);

    m_velocityVrChb = new JCheckBox("volume rendering");
    velocityPanel.add(m_velocityVrChb);
    m_velocityVrChb.setAlignmentX(Component.LEFT_ALIGNMENT);

    // Amplitude
    JPanel amplitudePanel = new JPanel();
    panel.add(amplitudePanel);
    amplitudePanel.setBorder(
        BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.GREEN), "Amplitude 205 x 361 x 58"));
    amplitudePanel.setLayout(new BoxLayout(amplitudePanel, BoxLayout.Y_AXIS));

    JPanel amplitudeSlicePanel = new JPanel();
    amplitudePanel.add(amplitudeSlicePanel);
    amplitudeSlicePanel.setLayout(new FlowLayout(FlowLayout.LEFT));
    ((FlowLayout) amplitudeSlicePanel.getLayout()).setHgap(0);
    amplitudeSlicePanel.setAlignmentX(Component.LEFT_ALIGNMENT);

    m_amplitudeSliceChb = new JCheckBox("slice");
    m_amplitudeSliceChb.setSelected(true);
    amplitudeSlicePanel.add(m_amplitudeSliceChb);

    m_amplitudeSliceSlider = new JSlider(0, 58, 32);
    amplitudeSlicePanel.add(m_amplitudeSliceSlider);

    m_amplitudeVrChb = new JCheckBox("volume rendering");
    amplitudePanel.add(m_amplitudeVrChb);
    m_amplitudeVrChb.setAlignmentX(Component.LEFT_ALIGNMENT);

    // Blending
    JPanel combinePanel = new JPanel();
    panel.add(combinePanel);
    combinePanel.setBorder(BorderFactory.createTitledBorder("Volume blending"));
    combinePanel.setLayout(new FlowLayout(FlowLayout.LEFT));
    combinePanel.add(new JLabel("level %"));

    m_combineSlider = new JSlider(0, 100, 50);
    combinePanel.add(m_combineSlider);
    combinePanel.setPreferredSize(new Dimension((int) combinePanel.getPreferredSize().getWidth(),
        (int) amplitudePanel.getPreferredSize().getHeight()));

    // Connections
    // velocity
    m_velocitySliceChb.addItemListener(new ItemListener()
    {
      @Override
      public void itemStateChanged(ItemEvent e)
      {
        if ( e.getStateChange() == ItemEvent.SELECTED )
        {
          m_orthoVelocitySwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
          m_velocitySliceSlider.setEnabled(true);
        }
        else
        {
          m_orthoVelocitySwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
          m_velocitySliceSlider.setEnabled(false);
        }
      }
    });

    m_velocitySliceSlider.addChangeListener(new ChangeListener()
    {

      @Override
      public void stateChanged(ChangeEvent e)
      {
        JSlider source = (JSlider) e.getSource();
        m_orthoVelocitySlice.sliceNumber.setValue((int) source.getValue());
      }
    });

    m_velocityVrChb.addItemListener(new ItemListener()
    {
      @Override
      public void itemStateChanged(ItemEvent e)
      {
        manageVolumeRender();
      }
    });

    // amplitude
    m_amplitudeSliceChb.addItemListener(new ItemListener()
    {
      @Override
      public void itemStateChanged(ItemEvent e)
      {
        if ( e.getStateChange() == ItemEvent.SELECTED )
        {
          m_orthoAmplitudeSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
          m_amplitudeSliceSlider.setEnabled(true);
        }
        else
        {
          m_orthoAmplitudeSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
          m_amplitudeSliceSlider.setEnabled(false);
        }
      }
    });

    m_amplitudeSliceSlider.addChangeListener(new ChangeListener()
    {

      @Override
      public void stateChanged(ChangeEvent e)
      {
        JSlider source = (JSlider) e.getSource();
        m_orthoAmplitudeSlice.sliceNumber.setValue((int) source.getValue());
      }
    });

    m_amplitudeVrChb.addItemListener(new ItemListener()
    {
      @Override
      public void itemStateChanged(ItemEvent e)
      {
        manageVolumeRender();
      }
    });

    m_combineSlider.addChangeListener(new ChangeListener()
    {

      @Override
      public void stateChanged(ChangeEvent e)
      {
        JSlider source = (JSlider) e.getSource();
        m_combinedPercentageShaderParam.value.setValue((float) source.getValue() / 100);
      }
    });

    return panel;
  }

  ////////////////////////////////////////////////////////////////////////
  // Helper for Bbox creation
  SoSeparator CreateBBox(SbBox3f bbox)
  {
    SoSeparator bboxSep = new SoSeparator();

    SoPickStyle pickStyle = new SoPickStyle();
    bboxSep.addChild(pickStyle);
    pickStyle.style.setValue(SoPickStyle.Styles.UNPICKABLE);

    SoDrawStyle drawStyle = new SoDrawStyle();
    bboxSep.addChild(drawStyle);
    drawStyle.style.setValue(SoDrawStyle.Styles.LINES);
    drawStyle.lineWidth.setValue(1.5f);
    drawStyle.linePattern.setValue((short) 0x8888);

    SoBaseColor bboxMat = new SoBaseColor();
    bboxMat.rgb.setValue(new SbVec3f(0.75f, 0.0f, 0.0f));
    bboxSep.addChild(bboxMat);

    SoLightModel lightModel = new SoLightModel();
    bboxSep.addChild(lightModel);
    lightModel.model.setValue(SoLightModel.Models.BASE_COLOR);

    SoTranslation translation = new SoTranslation();
    bboxSep.addChild(translation);
    translation.translation.setValue(bbox.getCenter());

    SoCube cube = new SoCube();
    SbVec3f bboxSize = bbox.getSize();
    cube.width.setValue(bboxSize.getX());
    cube.height.setValue(bboxSize.getY());
    cube.depth.setValue(bboxSize.getZ());
    bboxSep.addChild(cube);

    return bboxSep;
  }

  ////////////////////////////////////////////////////////////////////////
  //
  // Make synthetic velocity volume (not realistic)
  SoVolumeData makeVelocityVolume(SbVec3i32 volDim)
  {
    // Allocate memory for volume2 and assign values
    int testXdim = volDim.getValueAt(0);
    int testYdim = volDim.getValueAt(1);
    int testZdim = volDim.getValueAt(2);
    int numTestBytes = testXdim * testYdim * testZdim;
    ByteBuffer testData = ByteBuffer.allocateDirect(numTestBytes);
    testData.order(ByteOrder.nativeOrder());
    float ymax = (float) (testYdim - 1);
    for ( int i = 0; i < testZdim; i++ )
    {
      for ( int j = 0; j < testYdim; j++ )
      {
        int value = (int) (((float) j / ymax) * 255);
        for ( int k = 0; k < testXdim; k++ )
        {
          float rad = (float) k / (testXdim - 1);
          if ( rad > 0.75 )
            rad = 0.75f;
          rad *= (float) (2 * Math.PI);
          float offset = (float) -Math.sin(rad);
          offset *= 30 * (1 - ((float) j / ymax));
          int val = value + (int) (offset) - i / 2;
          if ( val < 1 )
            val = 1;
          else if ( val > 255 )
            val = 255;
          testData.put((byte) (255 - (byte) val));
        }
      }
    }

    // Create node and associate data with it.
    SoVolumeData pVolData2 = new SoVolumeData();
    pVolData2.data.setValue(volDim, new SbDataType(SbDataType.DataTypes.UNSIGNED_BYTE), 0, testData,
        SoSFArray.CopyPolicies.COPY);
    return pVolData2;
  }

  ////////////////////////////////////////////////////////////////////////
  //
  // Manage volume opacity
  void updateOpacity(SoTransferFunction tf, float opacity)
  {
    opacity = (float) (1.f - Math.pow(1-opacity, 1.f/16.f));
    FloatBuffer rgba = tf.actualColorMap.startEditing();
    for ( int i = 0; i < 256; i++ )
    {
      rgba.put(i * 4 + 3, opacity);
    }
    tf.actualColorMap.finishEditing();
  }

  ////////////////////////////////////////////////////////////////////////
  //
  // Manage volume rendering
  void manageVolumeRender()
  {
    m_vRender.dataSetIds.deleteValues(0, 2);
    int k = 0;
    if ( m_amplitudeVrChb.isSelected() )
    {
      m_vRender.dataSetIds.set1Value(k, 1);
      k++;
    }
    if ( m_velocityVrChb.isSelected() )
    {
      m_vRender.dataSetIds.set1Value(k, 2);
    }
    m_volumeSwitch.whichChild
        .setValue(m_vRender.dataSetIds.getNum() == 0 ? SoSwitch.SO_SWITCH_NONE : SoSwitch.SO_SWITCH_ALL);
  }

  @Override
  public void stop()
  {
    m_viewer.dispose();
  }

  public static void main(String[] argv)
  {
    Main example = new Main();
    example.demoMain("Amplitude + Velocity");
  }
}
