package volumeviz.sample.bonesMuscles;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.actions.SoGLRenderAction;
import com.openinventor.inventor.events.SoLocation2Event;
import com.openinventor.inventor.events.SoMouseButtonEvent;
import com.openinventor.inventor.nodes.SoCamera;
import com.openinventor.inventor.nodes.SoCube;
import com.openinventor.inventor.nodes.SoDirectionalLight;
import com.openinventor.inventor.nodes.SoEventCallback;
import com.openinventor.inventor.nodes.SoFont;
import com.openinventor.inventor.nodes.SoGradientBackground;
import com.openinventor.inventor.nodes.SoInteractiveComplexity;
import com.openinventor.inventor.nodes.SoLightModel;
import com.openinventor.inventor.nodes.SoOrthographicCamera;
import com.openinventor.inventor.nodes.SoPhysicalMaterial;
import com.openinventor.inventor.nodes.SoRotationXYZ;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoShadowGroup;
import com.openinventor.inventor.nodes.SoText2;
import com.openinventor.inventor.nodes.SoTextProperty;
import com.openinventor.inventor.nodes.SoTranslation;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.ldm.nodes.SoDataRange;
import com.openinventor.ldm.nodes.SoTransferFunction;
import com.openinventor.volumeviz.nodes.SoVolumeData;
import com.openinventor.volumeviz.nodes.SoVolumeRender;
import com.openinventor.volumeviz.nodes.SoVolumeRenderingQuality;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{
  // Data Set
  static final String FILENAME = "$OIVJHOME/data/volumeviz/medicalFoot.ldm";
  // color map
  static final String COLORMAP_FILENAME = "/data/volumeviz/bonesMuscles.col.am";

  private IViewerExaminer myViewer;

  @Override
  public void start()
  {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    SoSeparator root = new SoSeparator();

    // Separator for data.
    SoSeparator dataSep = new SoSeparator();

    // additional light source
    SoDirectionalLight light = new SoDirectionalLight();
    light.direction.setValue(0.4f, -0.25f, -0.87f);

    // Increase the rendering quality when you stop to move the dataset.
    SoInteractiveComplexity cplx = new SoInteractiveComplexity();

    // All data under this group will be shadowed.
    SoShadowGroup data = new SoShadowGroup();
    data.method.setValue(SoShadowGroup.ShadowingMethods.VARIANCE_SHADOW_MAP);
    data.quality.setValue(3.0f);
    data.intensity.setValue(0.7f);
    data.smoothFactor.setValue(4);
    data.isActive.setValue(true);

    // Separator for the foot support.
    SoSeparator suppportSep = new SoSeparator();
    SoTranslation suppTrans = new SoTranslation();
    suppTrans.translation.setValue(10, 0f, 0f);

    SoPhysicalMaterial supportMaterial = new SoPhysicalMaterial();
    supportMaterial.baseColor.setValue(1.0f, 1.0f, 1.0f, 1.0f);
    supportMaterial.roughness.setValue(1.0f);

    // The support.
    SoCube support = new SoCube();
    support.depth.setValue(50.0f);
    support.width.setValue(50.0f);
    support.height.setValue(0.05f);

    // Node to hold the volume data
    SoVolumeData volData = new SoVolumeData();
    // Load the model in the SoVolumeData
    volData.fileName.setValue(FILENAME);

    // Load the colorMap
    SoTransferFunction transFunc = new SoTransferFunction();
    transFunc.loadColormap(SoPreferences.getValue("OIVJHOME") + COLORMAP_FILENAME);

    // Set data default range.
    SoDataRange localDataRange = new SoDataRange();
    localDataRange.min.setValue(-868.93f);
    localDataRange.max.setValue(2659.00f);

    // Property node which allows SoVolumeRender to draw High Quality volumes.
    SoVolumeRenderingQuality vRVolQuality = new SoVolumeRenderingQuality();
    vRVolQuality.lighting.setValue(true);
    vRVolQuality.preIntegrated.setValue(true);
    vRVolQuality.edgeColoring.setValue(true);
    vRVolQuality.jittering.setValue(true);
    vRVolQuality.gradientQuality.setValue(SoVolumeRenderingQuality.GradientQualities.MEDIUM);

    // Node in charge of drawing the volume
    SoVolumeRender volRender = new SoVolumeRender();
    volRender.numSlicesControl.setValue(SoVolumeRender.NumSlicesControls.MANUAL);
    volRender.samplingAlignment.setValue(SoVolumeRender.SamplingAlignments.VIEW_ALIGNED);
    volRender.numSlices.setValue(512);

    SoLightModel lightModel = new SoLightModel();
    lightModel.model.setValue(SoLightModel.Models.PHYSICALLY_BASED);

    // Set the parameters of the material
    SoPhysicalMaterial material = new SoPhysicalMaterial();
    material.baseColor.setValue(1.0f, 1.0f, 1.0f, 1.0f);
    material.specular.setValue(1.0f);
    material.roughness.setValue(0.4f);

    // Define background color
    SoGradientBackground bg = new SoGradientBackground();

    SoRotationXYZ rotX = new SoRotationXYZ();
    rotX.axis.setValue(SoRotationXYZ.AxisType.X);
    rotX.angle.setValue(-3.14f / 2);
    SoRotationXYZ rotZ = new SoRotationXYZ();
    rotZ.axis.setValue(SoRotationXYZ.AxisType.Z);
    rotZ.angle.setValue(-3.14f / 2);

    // Mouse event callback to manage data range.
    SoEventCallback mouseMoveEvent = new SoEventCallback();
    SoEventCallback mouseKeyEvent = new SoEventCallback();

    // Text 2D to inform the user.
    SoSeparator localAnnotation = new SoSeparator();
    // Text 2D font.
    SoFont textFont = new SoFont();
    textFont.size.setValue(12);

    // Text 2D properties
    SoTextProperty textProperty = new SoTextProperty();
    textProperty.alignmentV.setValue(SoTextProperty.AlignmentVs.TOP);
    textProperty.margin.setValue(0.4f);

    SoTranslation textTrans = new SoTranslation();
    textTrans.translation.setValue(-1.0f, 1.0f, 0.0f);

    SoText2 instruction = new SoText2();
    instruction.string.set1Value(0, "In selection mode :");
    instruction.string.set1Value(1, "  . Drag horizontally with left mouse button pressed to change the min data range.");
    instruction.string.set1Value(2, "  . Drag vertically with left mouse button pressed to change the max data range.");

    // Add Children
    root.addChild(dataSep);

    dataSep.addChild(light);
    dataSep.addChild(cplx);
    cplx.fieldSettings.set1Value(0, "SoVolumeRender numSlices 200 1000 1500");
    cplx.fieldSettings.set1Value(1, "SoVolumeRender lowScreenResolutionScale 2 1 -1");
    cplx.fieldSettings.set1Value(2, "SoVolumeRenderingQuality gradientQuality LOW MEDIUM");

    dataSep.addChild(lightModel);
    dataSep.addChild(material);
    dataSep.addChild(bg);
    dataSep.addChild(data);

    data.addChild(suppportSep);
    suppportSep.addChild(suppTrans);
    suppportSep.addChild(supportMaterial);
    suppportSep.addChild(support);

    data.addChild(rotX);
    data.addChild(rotZ);
    data.addChild(volData);
    data.addChild(localDataRange);
    data.addChild(transFunc);
    data.addChild(vRVolQuality);
    data.addChild(volRender);
    data.addChild(mouseMoveEvent);
    data.addChild(mouseKeyEvent);

    root.addChild(localAnnotation);
    // Camera for Text 2D.
    SoOrthographicCamera annotCam = new SoOrthographicCamera();
    annotCam.viewportMapping.setValue(SoCamera.ViewportMappings.LEAVE_ALONE);
    localAnnotation.addChild(annotCam);
    localAnnotation.addChild(textFont);
    localAnnotation.addChild(textProperty);
    localAnnotation.addChild(textTrans);
    localAnnotation.addChild(instruction);

    // get mouse events to change the colormap ranges.
    MouseEventsCB mouseEventsCB = new MouseEventsCB(localDataRange);
    mouseMoveEvent.addEventCallback(SoLocation2Event.class, mouseEventsCB, null);
    mouseKeyEvent.addEventCallback(SoMouseButtonEvent.class, mouseEventsCB, null);

    // Set up viewer:
    myViewer.setSceneGraph(root);
    myViewer.getRenderArea().setTransparencyType(SoGLRenderAction.TransparencyTypes.NO_SORT);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String argv[])
  {
    Main example = new Main();
    example.demoMain("Bones  Muscles");
  }
}
