/*----------------------------------------------------------------------------------------
Example program.
Purpose : Demonstrate how to create and use a color map
author : Jerome Hummel
----------------------------------------------------------------------------------------*/
package volumeviz.sample.colorMap;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.nodes.SoGradientBackground;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.ldm.nodes.SoTransferFunction;
import com.openinventor.volumeviz.nodes.SoVolumeData;
import com.openinventor.volumeviz.nodes.SoVolumeRender;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  //file name
  static final String fileName = "$OIVJHOME/data/volumeviz/virus.am";

  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("ColorMap");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    // Create volumeData node with a filename
    // Note: VolumeViz will try to open and load the data using one
    //       of the builtin file loaders (see SoVolumeReader).
    SoVolumeData pVolData = new SoVolumeData();
    pVolData.fileName.setValue(fileName);

    // Transfer function description
    // Using a predefined color map would use for example this code :
    // SoTransferFunction pTransFunc = new SoTransferFunction();
    // pTransFunc.predefColorMap.setValue(SoTransferFunction.GREY);

    // But we want to create a new colorMap here.
    // For demo purposes, this code shows how to create the predefined
    // STANDARD colorMap with 256 entries.
    SoTransferFunction pTransFunc = new SoTransferFunction();
    int numEntries = 256;
    for (int i = 0; i < numEntries; i++) {
      float f = (float)i / 255;
      SbColor rgb = new SbColor();
      rgb.setHSVValue( 0.916f * f, 1, 1 );
      pTransFunc.colorMap.set1Value(4 * i + 0, rgb.getValueAt(0)); // red
      pTransFunc.colorMap.set1Value(4 * i + 1, rgb.getValueAt(1)); // green
      pTransFunc.colorMap.set1Value(4 * i + 2, rgb.getValueAt(2)); // blue
      pTransFunc.colorMap.set1Value(4 * i + 3, 0.3f); // alpha
    }

    // Create the render node to draw the volume based on data and transfer function
    SoVolumeRender pVolRender = new SoVolumeRender();

    SbColor bkgColor = new SbColor(new SbColor(.7f, .7f, .7f));
    SoGradientBackground background = new SoGradientBackground();
    background.color0.setValue(bkgColor);
    background.color1.setValue(bkgColor);

    SoSeparator root = new SoSeparator();
    { // Assemble the sceneGraph
      root.addChild(background);
      root.addChild(pVolData);
      root.addChild(pTransFunc);
      root.addChild(pVolRender);
    }

    // Set up viewer:
    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }
}
