package volumeviz.sample.dataTransform;

import java.awt.BorderLayout;
import java.awt.Component;
import java.nio.ByteBuffer;

import com.openinventor.inventor.SbBox3i32;
import com.openinventor.inventor.SbVec3i32;
import com.openinventor.inventor.devices.SoBufferObject;
import com.openinventor.inventor.devices.SoCpuBufferObject;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.ldm.SoLDMGlobalResourceParameters;
import com.openinventor.ldm.nodes.SoDataSet;
import com.openinventor.ldm.nodes.SoLDMDataTransform;
import com.openinventor.ldm.nodes.SoTransferFunction;
import com.openinventor.volumeviz.nodes.SoVolumeData;
import com.openinventor.volumeviz.nodes.SoVolumeRender;

import util.Example;
import util.ViewerComponentsFactory;

/**
 * Demonstrates how to use the data transform feature of SoDataSet used for
 * example for attribute calculation.
 *
 */
public class Main extends Example
{
  // Data Set
  private static final String FILENAME = "$OIVJHOME/data/volumeviz/3DHEAD.ldm";

  private IViewerExaminer myViewer;

  @Override
  public void start()
  {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    SoLDMGlobalResourceParameters.setIgnoreFullyTransparentTiles(false);

    // Node to hold the volume data
    SoVolumeData volData = new SoVolumeData();
    volData.fileName.setValue(FILENAME);

    // set the function that must be called before to store the data in main
    // memory
    DataTransformer transformer = new DataTransformer();
    volData.dataTransform.setValue(transformer);

    // Use a predefined colorMap with the SoTransferFunction
    SoTransferFunction transFunc = new SoTransferFunction();
    transFunc.predefColorMap.setValue(SoTransferFunction.PredefColorMaps.STANDARD);
    transFunc.minValue.setValue(20);
    transFunc.maxValue.setValue(250);

    // Node in charge of drawing the volume
    SoVolumeRender volRender = new SoVolumeRender();
    volRender.samplingAlignment.setValue(SoVolumeRender.SamplingAlignments.DATA_ALIGNED);

    SoSeparator root = new SoSeparator();
    {
      root.addChild(volData);
      root.addChild(transFunc);
      root.addChild(volRender);
    }

    // Set up viewer:
    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String argv[])
  {
    Main example = new Main();
    example.demoMain("Data Transform");
  }

  class DataTransformer extends SoLDMDataTransform
  {
    @Override
    public void transformFunction(SoDataSet ds, SbVec3i32 bufferDimension, SoBufferObject bufferToTransform,
        SbBox3i32 dataBox, int resolutionLevel)
    {
      SoCpuBufferObject cpuObj = new SoCpuBufferObject();

      bufferToTransform.map(cpuObj, SoCpuBufferObject.AccessModes.READ_WRITE);
      ByteBuffer buffer = cpuObj.map(SoCpuBufferObject.AccessModes.READ_WRITE);
      buffer.rewind();

      SbVec3i32 dataBoxMin = dataBox.getMin();
      // Do the real work
      if ( resolutionLevel == 1 || resolutionLevel == 0
          && (dataBoxMin.array[0] == 0 && dataBoxMin.array[1] == 0 && dataBoxMin.array[2] == 0) )
      {
        int crossWidth = 10;
        int ijk = 0;
        for ( int k = 0; k < bufferDimension.array[2]; k++ )
          for ( int j = 0; j < bufferDimension.array[1]; j++ )
            for ( int i = 0; i < bufferDimension.array[0]; i++ )
            {
              buffer.put(ijk, (byte) 0);
              if ( j > bufferDimension.array[1] / 2 - crossWidth && j < bufferDimension.array[1] / 2 + crossWidth )
                buffer.put(ijk, (byte) 125);
              else if ( i > bufferDimension.array[0] / 2 - crossWidth && i < bufferDimension.array[0] / 2 + crossWidth )
                buffer.put(ijk, (byte) 125);

              ijk++;
            }
      }

      cpuObj.unmap();
      bufferToTransform.unmap(cpuObj);
    }
  }
}
