package volumeviz.sample.edge2D;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.actions.SoSearchAction;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.ldm.SoLDMGlobalResourceParameters;
import com.openinventor.volumeviz.nodes.SoVolumeRenderingQuality;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{
  SoVolumeRenderingQuality volumeRenderQuality;

  static final String DATA_FILE = "$OIVJHOME/data/volumeviz/scene_edge2D.iv";

  private IViewerExaminer myViewer;

  private SoNode searchNode(SoNode scene, Class<? extends Inventor> c)
  {
    SoSearchAction sa = new SoSearchAction();
    sa.setNodeClass(c);
    sa.apply(scene);

    SoPath path = sa.getPath();
    if ( path == null )
    {
      System.err.println(c.getName() + " not found");
      return null;
    }

    return path.regular.getTail();
  }

  private static SoSeparator readSceneGraph(String fileName)
  {
    SoInput input = new SoInput();

    if ( !input.openFile(fileName) )
    {
      System.err.println("Cannot open file " + fileName);
      return null;
    }

    SoSeparator node = SoDB.readAll(input);
    if ( node == null )
    {
      System.err.println("Problem reading file");
      input.closeFile();
      return null;
    }

    input.closeFile();
    return node;
  }

  @Override
  public void start()
  {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    SoLDMGlobalResourceParameters.setViewCulling(false);
    SoLDMGlobalResourceParameters.setViewpointRefinement(false);
    SoLDMGlobalResourceParameters.setScreenResolutionCulling(false);

    // Open the input file
    SoSeparator scene = readSceneGraph(DATA_FILE);

    SoSeparator root = new SoSeparator();
    root.addChild(scene);

    volumeRenderQuality = (SoVolumeRenderingQuality) searchNode(scene, SoVolumeRenderingQuality.class);
    if ( volumeRenderQuality == null )
    {
      System.err.println("SoVolumeRenderingQuality not found");
      System.exit(0);
    }
    volumeRenderQuality.edgeDetect2DMethod.setValue(SoVolumeRenderingQuality.EdgeDetect2DMethods.LUMINANCE.getValue()
        | SoVolumeRenderingQuality.EdgeDetect2DMethods.DEPTH.getValue());
    volumeRenderQuality.surfaceScalarExponent.setValue(8.f);

    // Set up viewer:
    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    Edge2DOptionsPanel panel2 = new Edge2DOptionsPanel();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
    add(panel2, BorderLayout.SOUTH);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String argv[])
  {
    Main example = new Main();
    example.demoMain("Edge2D");
  }

  class Edge2DOptionsPanel extends javax.swing.JPanel
  {
    javax.swing.JCheckBox chkDepth;
    javax.swing.JCheckBox chkGradient;
    javax.swing.JCheckBox chkLuminance;
    javax.swing.JCheckBox chkSurfaceScalar;

    /** Creates new form Edge2DOptionsPanel */
    public Edge2DOptionsPanel()
    {
      initComponents();
    }

    private void chkDepthStateChanged(javax.swing.event.ChangeEvent evt)
    {
      int bitmask = volumeRenderQuality.edgeDetect2DMethod.getValue();
      int value;

      if ( chkDepth.isSelected() )
      {
        value = bitmask | SoVolumeRenderingQuality.EdgeDetect2DMethods.DEPTH.getValue();
      }
      else
      {
        value = bitmask & ~SoVolumeRenderingQuality.EdgeDetect2DMethods.DEPTH.getValue();
      }

      volumeRenderQuality.edgeDetect2DMethod.setValue(value);
    }

    private void chkGradientStateChanged(javax.swing.event.ChangeEvent evt)
    {
      chkSurfaceScalar.setEnabled(chkGradient.isSelected());

      int bitmask = volumeRenderQuality.edgeDetect2DMethod.getValue();
      int value;

      if ( chkGradient.isSelected() )
      {
        value = bitmask | SoVolumeRenderingQuality.EdgeDetect2DMethods.GRADIENT.getValue();
      }
      else
      {
        value = bitmask & ~SoVolumeRenderingQuality.EdgeDetect2DMethods.GRADIENT.getValue();
      }

      volumeRenderQuality.edgeDetect2DMethod.setValue(value);
    }

    private void chkLuminanceStateChanged(javax.swing.event.ChangeEvent evt)
    {
      int bitmask = volumeRenderQuality.edgeDetect2DMethod.getValue();
      int value;

      if ( chkLuminance.isSelected() )
      {
        value = bitmask | SoVolumeRenderingQuality.EdgeDetect2DMethods.LUMINANCE.getValue();
      }
      else
      {
        value = bitmask & ~SoVolumeRenderingQuality.EdgeDetect2DMethods.LUMINANCE.getValue();
      }

      volumeRenderQuality.edgeDetect2DMethod.setValue(value);
    }

    private void chkSurfaceScalarStateChanged(javax.swing.event.ChangeEvent evt)
    {
      if ( chkSurfaceScalar.isSelected() )
      {
        volumeRenderQuality.surfaceScalarExponent.setValue(8);
      }
      else
      {
        volumeRenderQuality.surfaceScalarExponent.setValue(0);
      }
    }

    private void initComponents()
    {
      chkLuminance = new javax.swing.JCheckBox();
      chkDepth = new javax.swing.JCheckBox();
      chkGradient = new javax.swing.JCheckBox();
      chkSurfaceScalar = new javax.swing.JCheckBox();

      setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.CENTER, 30, 5));

      chkLuminance.setSelected(true);
      chkLuminance.setText("Luminance");
      chkLuminance.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
      chkLuminance.addChangeListener(new javax.swing.event.ChangeListener()
      {
        @Override
        public void stateChanged(javax.swing.event.ChangeEvent evt)
        {
          chkLuminanceStateChanged(evt);
        }
      });
      add(chkLuminance);

      chkDepth.setSelected(true);
      chkDepth.setText("Depth");
      chkDepth.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
      chkDepth.addChangeListener(new javax.swing.event.ChangeListener()
      {
        @Override
        public void stateChanged(javax.swing.event.ChangeEvent evt)
        {
          chkDepthStateChanged(evt);
        }
      });
      add(chkDepth);

      chkGradient.setText("Gradient");
      chkGradient.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
      chkGradient.addChangeListener(new javax.swing.event.ChangeListener()
      {
        @Override
        public void stateChanged(javax.swing.event.ChangeEvent evt)
        {
          chkGradientStateChanged(evt);
        }
      });
      add(chkGradient);

      chkSurfaceScalar.setSelected(true);
      chkSurfaceScalar.setText("Surface scalar");
      chkSurfaceScalar.setEnabled(false);
      chkSurfaceScalar.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
      chkSurfaceScalar.addChangeListener(new javax.swing.event.ChangeListener()
      {
        @Override
        public void stateChanged(javax.swing.event.ChangeEvent evt)
        {
          chkSurfaceScalarStateChanged(evt);
        }
      });
      add(chkSurfaceScalar);
    }
  }
}
